/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.deep.Canvas;
import org.immutables.fixture.deep.ImmutableColor;
import org.immutables.fixture.deep.ImmutablePoint;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableLine
implements Canvas.Line {
    private final ImmutablePoint start;
    private final ImmutablePoint end;
    private final ImmutableColor color;

    private ImmutableLine(ImmutablePoint start, ImmutablePoint end, ImmutableColor color) {
        this.start = start;
        this.end = end;
        this.color = color;
    }

    @Override
    public ImmutablePoint start() {
        return this.start;
    }

    @Override
    public ImmutablePoint end() {
        return this.end;
    }

    @Override
    public ImmutableColor color() {
        return this.color;
    }

    public final ImmutableLine withStart(Canvas.Point value) {
        if (this.start == value) {
            return this;
        }
        ImmutablePoint newValue = ImmutablePoint.copyOf(value);
        return new ImmutableLine(newValue, this.end, this.color);
    }

    public final ImmutableLine withEnd(Canvas.Point value) {
        if (this.end == value) {
            return this;
        }
        ImmutablePoint newValue = ImmutablePoint.copyOf(value);
        return new ImmutableLine(this.start, newValue, this.color);
    }

    public final ImmutableLine withColor(Canvas.Color value) {
        if (this.color == value) {
            return this;
        }
        ImmutableColor newValue = ImmutableColor.copyOf(value);
        return new ImmutableLine(this.start, this.end, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLine && this.equalTo((ImmutableLine)another);
    }

    private boolean equalTo(ImmutableLine another) {
        return this.start.equals(another.start) && this.end.equals(another.end) && this.color.equals(another.color);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.start.hashCode();
        h = h * 17 + this.end.hashCode();
        h = h * 17 + this.color.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Line").add("start", (Object)this.start).add("end", (Object)this.end).add("color", (Object)this.color).toString();
    }

    public static ImmutableLine copyOf(Canvas.Line instance) {
        if (instance instanceof ImmutableLine) {
            return (ImmutableLine)instance;
        }
        return ImmutableLine.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_START = 1L;
        private static final long INIT_BIT_END = 2L;
        private static final long INIT_BIT_COLOR = 4L;
        private long initBits = 7L;
        @Nullable
        private Canvas.Point start;
        @Nullable
        private Canvas.Point end;
        @Nullable
        private Canvas.Color color;

        private Builder() {
        }

        public final Builder from(Canvas.Line instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.start(instance.start());
            this.end(instance.end());
            this.color(instance.color());
            return this;
        }

        public final Builder startOf(int x, int y) {
            this.start = ImmutablePoint.of(x, y);
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder start(Canvas.Point start) {
            this.start = ImmutablePoint.copyOf(start);
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder endOf(int x, int y) {
            this.end = ImmutablePoint.of(x, y);
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder end(Canvas.Point end) {
            this.end = ImmutablePoint.copyOf(end);
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder colorOf(double red, double green, double blue) {
            this.color = ImmutableColor.of(red, green, blue);
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder color(Canvas.Color color) {
            this.color = ImmutableColor.copyOf(color);
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableLine build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLine(ImmutablePoint.copyOf(this.start), ImmutablePoint.copyOf(this.end), ImmutableColor.copyOf(this.color));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("start");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("end");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("color");
            }
            return "Cannot build Line, some of required attributes are not set " + attributes;
        }
    }
}

