/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.deep.Canvas;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutablePoint
implements Canvas.Point {
    private final int x;
    private final int y;

    private ImmutablePoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    public final ImmutablePoint withX(int value) {
        if (this.x == value) {
            return this;
        }
        return new ImmutablePoint(value, this.y);
    }

    public final ImmutablePoint withY(int value) {
        if (this.y == value) {
            return this;
        }
        return new ImmutablePoint(this.x, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePoint && this.equalTo((ImmutablePoint)another);
    }

    private boolean equalTo(ImmutablePoint another) {
        return this.x == another.x && this.y == another.y;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.x;
        h = h * 17 + this.y;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Point").add("x", this.x).add("y", this.y).toString();
    }

    public static ImmutablePoint of(int x, int y) {
        return new ImmutablePoint(x, y);
    }

    public static ImmutablePoint copyOf(Canvas.Point instance) {
        if (instance instanceof ImmutablePoint) {
            return (ImmutablePoint)instance;
        }
        return ImmutablePoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_X = 1L;
        private static final long INIT_BIT_Y = 2L;
        private long initBits = 3L;
        private int x;
        private int y;

        private Builder() {
        }

        public final Builder from(Canvas.Point instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.x(instance.x());
            this.y(instance.y());
            return this;
        }

        public final Builder x(int x) {
            this.x = x;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder y(int y) {
            this.y = y;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePoint build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePoint(this.x, this.y);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("x");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("y");
            }
            return "Cannot build Point, some of required attributes are not set " + attributes;
        }
    }
}

