/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.AnyGetterSetter;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableAnyGetterSetter
implements AnyGetterSetter {
    private final ImmutableMap<String, Object> any;

    private ImmutableAnyGetterSetter(ImmutableMap<String, Object> any) {
        this.any = any;
    }

    @JsonProperty
    @JsonAnyGetter
    public ImmutableMap<String, Object> getAny() {
        return this.any;
    }

    public final ImmutableAnyGetterSetter withAny(Map<String, ? extends Object> entries) {
        if (this.any == entries) {
            return this;
        }
        ImmutableMap value = ImmutableMap.copyOf(entries);
        return new ImmutableAnyGetterSetter((ImmutableMap<String, Object>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAnyGetterSetter && this.equalTo((ImmutableAnyGetterSetter)another);
    }

    private boolean equalTo(ImmutableAnyGetterSetter another) {
        return this.any.equals(another.any);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.any.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AnyGetterSetter").add("any", this.any).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableAnyGetterSetter fromJson(Json json) {
        Builder builder = ImmutableAnyGetterSetter.builder();
        if (json.any != null) {
            builder.putAllAny(json.any);
        }
        return builder.build();
    }

    public static ImmutableAnyGetterSetter copyOf(AnyGetterSetter instance) {
        if (instance instanceof ImmutableAnyGetterSetter) {
            return (ImmutableAnyGetterSetter)instance;
        }
        return ImmutableAnyGetterSetter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableMap.Builder<String, Object> anyBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public final Builder from(AnyGetterSetter instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.putAllAny(instance.getAny());
            return this;
        }

        public final Builder putAny(String key, Object value) {
            this.anyBuilder.put((Object)key, value);
            return this;
        }

        public final Builder putAny(Map.Entry<String, ? extends Object> entry) {
            this.anyBuilder.put(entry);
            return this;
        }

        public final Builder any(Map<String, ? extends Object> entries) {
            this.anyBuilder = ImmutableMap.builder();
            return this.putAllAny(entries);
        }

        public final Builder putAllAny(Map<String, ? extends Object> entries) {
            this.anyBuilder.putAll(entries);
            return this;
        }

        public ImmutableAnyGetterSetter build() throws IllegalStateException {
            return new ImmutableAnyGetterSetter(this.anyBuilder.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    implements AnyGetterSetter {
        final Map<String, Object> any = new HashMap<String, Object>();

        Json() {
        }

        @JsonAnySetter
        public void setAny(String key, Object value) {
            this.any.put(key, value);
        }

        @Override
        public Map<String, Object> getAny() {
            throw new UnsupportedOperationException();
        }
    }
}

