/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.fixture.jackson.ConstructorJacksonMapped;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableConstructorJacksonMapped
implements ConstructorJacksonMapped {
    private final int instance;
    private final String bal;

    private ImmutableConstructorJacksonMapped(int instance, String bal) {
        this.instance = instance;
        this.bal = (String)Preconditions.checkNotNull((Object)bal, (Object)"bal");
    }

    private ImmutableConstructorJacksonMapped(ImmutableConstructorJacksonMapped original, int instance, String bal) {
        this.instance = instance;
        this.bal = bal;
    }

    @Override
    @JsonProperty(value="X")
    public int instance() {
        return this.instance;
    }

    @Override
    @JsonProperty
    public String bal() {
        return this.bal;
    }

    public final ImmutableConstructorJacksonMapped withInstance(int value) {
        if (this.instance == value) {
            return this;
        }
        return new ImmutableConstructorJacksonMapped(this, value, this.bal);
    }

    public final ImmutableConstructorJacksonMapped withBal(String value) {
        if (this.bal.equals(value)) {
            return this;
        }
        return new ImmutableConstructorJacksonMapped(this, this.instance, (String)Preconditions.checkNotNull((Object)value, (Object)"bal"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConstructorJacksonMapped && this.equalTo((ImmutableConstructorJacksonMapped)another);
    }

    private boolean equalTo(ImmutableConstructorJacksonMapped another) {
        return this.instance == another.instance && this.bal.equals(another.bal);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.instance;
        h = h * 17 + this.bal.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConstructorJacksonMapped").add("instance", this.instance).add("bal", (Object)this.bal).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableConstructorJacksonMapped fromJson(Json json) {
        ImmutableConstructorJacksonMapped instance = ImmutableConstructorJacksonMapped.of(json.instance, json.bal);
        return instance;
    }

    public static ImmutableConstructorJacksonMapped of(int instance, String bal) {
        return new ImmutableConstructorJacksonMapped(instance, bal);
    }

    public static ImmutableConstructorJacksonMapped copyOf(ConstructorJacksonMapped instance) {
        if (instance instanceof ImmutableConstructorJacksonMapped) {
            return (ImmutableConstructorJacksonMapped)instance;
        }
        return ImmutableConstructorJacksonMapped.of(instance.instance(), instance.bal());
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    implements ConstructorJacksonMapped {
        @Nullable
        Integer instance;
        @Nullable
        String bal;

        Json() {
        }

        @JsonProperty(value="X")
        public void setInstance(int instance) {
            this.instance = instance;
        }

        @JsonProperty
        public void setBal(String bal) {
            this.bal = bal;
        }

        @Override
        public int instance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String bal() {
            throw new UnsupportedOperationException();
        }
    }
}

