/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.PolymorphicMappings;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableDatasetIdLocator
implements PolymorphicMappings.DatasetIdLocator {
    private final String datasetId;

    private ImmutableDatasetIdLocator(String datasetId) {
        this.datasetId = datasetId;
    }

    @Override
    @JsonProperty
    public String getDatasetId() {
        return this.datasetId;
    }

    public final ImmutableDatasetIdLocator withDatasetId(String value) {
        if (this.datasetId.equals(value)) {
            return this;
        }
        return new ImmutableDatasetIdLocator((String)Preconditions.checkNotNull((Object)value, (Object)"datasetId"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDatasetIdLocator && this.equalTo((ImmutableDatasetIdLocator)another);
    }

    private boolean equalTo(ImmutableDatasetIdLocator another) {
        return this.datasetId.equals(another.datasetId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.datasetId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DatasetIdLocator").add("datasetId", (Object)this.datasetId).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableDatasetIdLocator fromJson(Json json) {
        PolymorphicMappings.DatasetIdLocator.Builder builder = new PolymorphicMappings.DatasetIdLocator.Builder();
        if (json.datasetId != null) {
            builder.datasetId(json.datasetId);
        }
        return builder.build();
    }

    public static ImmutableDatasetIdLocator copyOf(PolymorphicMappings.DatasetIdLocator instance) {
        if (instance instanceof ImmutableDatasetIdLocator) {
            return (ImmutableDatasetIdLocator)instance;
        }
        return new PolymorphicMappings.DatasetIdLocator.Builder().from(instance).build();
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_DATASET_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String datasetId;

        Builder() {
            if (!(this instanceof PolymorphicMappings.DatasetIdLocator.Builder)) {
                throw new UnsupportedOperationException("Use: new PolymorphicMappings.DatasetIdLocator.Builder()");
            }
        }

        public final PolymorphicMappings.DatasetIdLocator.Builder from(PolymorphicMappings.DatasetIdLocator instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.datasetId(instance.getDatasetId());
            return (PolymorphicMappings.DatasetIdLocator.Builder)this;
        }

        public final PolymorphicMappings.DatasetIdLocator.Builder datasetId(String datasetId) {
            this.datasetId = (String)Preconditions.checkNotNull((Object)datasetId, (Object)"datasetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (PolymorphicMappings.DatasetIdLocator.Builder)this;
        }

        public ImmutableDatasetIdLocator build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDatasetIdLocator(this.datasetId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("datasetId");
            }
            return "Cannot build DatasetIdLocator, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    static final class Json
    implements PolymorphicMappings.DatasetIdLocator {
        @Nullable
        String datasetId;

        Json() {
        }

        @JsonProperty
        public void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public String getDatasetId() {
            throw new UnsupportedOperationException();
        }
    }
}

