/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.PolymorphicMappings;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableDatasetPathLocator
implements PolymorphicMappings.DatasetPathLocator {
    private final String datasetPath;

    private ImmutableDatasetPathLocator(String datasetPath) {
        this.datasetPath = datasetPath;
    }

    @Override
    @JsonProperty
    public String getDatasetPath() {
        return this.datasetPath;
    }

    public final ImmutableDatasetPathLocator withDatasetPath(String value) {
        if (this.datasetPath.equals(value)) {
            return this;
        }
        return new ImmutableDatasetPathLocator((String)Preconditions.checkNotNull((Object)value, (Object)"datasetPath"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDatasetPathLocator && this.equalTo((ImmutableDatasetPathLocator)another);
    }

    private boolean equalTo(ImmutableDatasetPathLocator another) {
        return this.datasetPath.equals(another.datasetPath);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.datasetPath.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DatasetPathLocator").add("datasetPath", (Object)this.datasetPath).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableDatasetPathLocator fromJson(Json json) {
        PolymorphicMappings.DatasetPathLocator.Builder builder = new PolymorphicMappings.DatasetPathLocator.Builder();
        if (json.datasetPath != null) {
            builder.datasetPath(json.datasetPath);
        }
        return builder.build();
    }

    public static ImmutableDatasetPathLocator copyOf(PolymorphicMappings.DatasetPathLocator instance) {
        if (instance instanceof ImmutableDatasetPathLocator) {
            return (ImmutableDatasetPathLocator)instance;
        }
        return new PolymorphicMappings.DatasetPathLocator.Builder().from(instance).build();
    }

    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_DATASET_PATH = 1L;
        private long initBits = 1L;
        @Nullable
        private String datasetPath;

        Builder() {
            if (!(this instanceof PolymorphicMappings.DatasetPathLocator.Builder)) {
                throw new UnsupportedOperationException("Use: new PolymorphicMappings.DatasetPathLocator.Builder()");
            }
        }

        public final PolymorphicMappings.DatasetPathLocator.Builder from(PolymorphicMappings.DatasetPathLocator instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.datasetPath(instance.getDatasetPath());
            return (PolymorphicMappings.DatasetPathLocator.Builder)this;
        }

        public final PolymorphicMappings.DatasetPathLocator.Builder datasetPath(String datasetPath) {
            this.datasetPath = (String)Preconditions.checkNotNull((Object)datasetPath, (Object)"datasetPath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (PolymorphicMappings.DatasetPathLocator.Builder)this;
        }

        public ImmutableDatasetPathLocator build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDatasetPathLocator(this.datasetPath);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("datasetPath");
            }
            return "Cannot build DatasetPathLocator, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    static final class Json
    implements PolymorphicMappings.DatasetPathLocator {
        @Nullable
        String datasetPath;

        Json() {
        }

        @JsonProperty
        public void setDatasetPath(String datasetPath) {
            this.datasetPath = datasetPath;
        }

        @Override
        public String getDatasetPath() {
            throw new UnsupportedOperationException();
        }
    }
}

