/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.Foo;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableFoo
extends Foo {
    private final boolean isBar;

    private ImmutableFoo(boolean isBar) {
        this.isBar = isBar;
    }

    @Override
    @JsonProperty(value="bar")
    public boolean isBar() {
        return this.isBar;
    }

    public final ImmutableFoo withIsBar(boolean value) {
        if (this.isBar == value) {
            return this;
        }
        return new ImmutableFoo(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFoo && this.equalTo((ImmutableFoo)another);
    }

    private boolean equalTo(ImmutableFoo another) {
        return this.isBar == another.isBar;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode((boolean)this.isBar);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Foo").add("isBar", this.isBar).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableFoo fromJson(Json json) {
        Builder builder = ImmutableFoo.builder();
        if (json.isBar != null) {
            builder.isBar(json.isBar);
        }
        return builder.build();
    }

    public static ImmutableFoo copyOf(Foo instance) {
        if (instance instanceof ImmutableFoo) {
            return (ImmutableFoo)instance;
        }
        return ImmutableFoo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IS_BAR = 1L;
        private long initBits = 1L;
        private boolean isBar;

        private Builder() {
        }

        public final Builder from(Foo instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.isBar(instance.isBar());
            return this;
        }

        public final Builder isBar(boolean isBar) {
            this.isBar = isBar;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableFoo build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFoo(this.isBar);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("isBar");
            }
            return "Cannot build Foo, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Foo {
        @Nullable
        Boolean isBar;

        Json() {
        }

        @JsonProperty(value="bar")
        public void setIsBar(boolean isBar) {
            this.isBar = isBar;
        }

        @Override
        public boolean isBar() {
            throw new UnsupportedOperationException();
        }
    }
}

