/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.GeoPoint;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableGeoPoint
extends GeoPoint {
    private final double longitude;
    private final double latitude;
    private final double altitude;

    private ImmutableGeoPoint(double longitude, double latitude, double altitude) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.altitude = altitude;
    }

    @Override
    @JsonProperty
    public double longitude() {
        return this.longitude;
    }

    @Override
    @JsonProperty
    public double latitude() {
        return this.latitude;
    }

    @Override
    @JsonProperty
    public double altitude() {
        return this.altitude;
    }

    public final ImmutableGeoPoint withLongitude(double value) {
        if (Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableGeoPoint(value, this.latitude, this.altitude);
    }

    public final ImmutableGeoPoint withLatitude(double value) {
        if (Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableGeoPoint(this.longitude, value, this.altitude);
    }

    public final ImmutableGeoPoint withAltitude(double value) {
        if (Double.doubleToLongBits(this.altitude) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableGeoPoint(this.longitude, this.latitude, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGeoPoint && this.equalTo((ImmutableGeoPoint)another);
    }

    private boolean equalTo(ImmutableGeoPoint another) {
        return Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(another.longitude) && Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(another.latitude) && Double.doubleToLongBits(this.altitude) == Double.doubleToLongBits(another.altitude);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Doubles.hashCode((double)this.longitude);
        h = h * 17 + Doubles.hashCode((double)this.latitude);
        h = h * 17 + Doubles.hashCode((double)this.altitude);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GeoPoint").add("longitude", this.longitude).add("latitude", this.latitude).add("altitude", this.altitude).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableGeoPoint fromJson(Json json) {
        Builder builder = ImmutableGeoPoint.builder();
        if (json.longitude != null) {
            builder.longitude(json.longitude);
        }
        if (json.latitude != null) {
            builder.latitude(json.latitude);
        }
        if (json.altitude != null) {
            builder.altitude(json.altitude);
        }
        return builder.build();
    }

    public static ImmutableGeoPoint copyOf(GeoPoint instance) {
        if (instance instanceof ImmutableGeoPoint) {
            return (ImmutableGeoPoint)instance;
        }
        return ImmutableGeoPoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LONGITUDE = 1L;
        private static final long INIT_BIT_LATITUDE = 2L;
        private static final long INIT_BIT_ALTITUDE = 4L;
        private long initBits = 7L;
        private double longitude;
        private double latitude;
        private double altitude;

        private Builder() {
        }

        public final Builder from(GeoPoint instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.longitude(instance.longitude());
            this.latitude(instance.latitude());
            this.altitude(instance.altitude());
            return this;
        }

        public final Builder longitude(double longitude) {
            this.longitude = longitude;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder latitude(double latitude) {
            this.latitude = latitude;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder altitude(double altitude) {
            this.altitude = altitude;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGeoPoint build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGeoPoint(this.longitude, this.latitude, this.altitude);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("longitude");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("latitude");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("altitude");
            }
            return "Cannot build GeoPoint, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends GeoPoint {
        @Nullable
        Double longitude;
        @Nullable
        Double latitude;
        @Nullable
        Double altitude;

        Json() {
        }

        @JsonProperty
        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        @JsonProperty
        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        @JsonProperty
        public void setAltitude(double altitude) {
            this.altitude = altitude;
        }

        @Override
        public double longitude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double latitude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double altitude() {
            throw new UnsupportedOperationException();
        }
    }
}

