/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import nonimmutables.AdditionalJacksonAnnotation;
import org.immutables.fixture.jackson.JacksonMappedWithExtraAnnotation;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableJacksonMappedWithExtraAnnotation
implements JacksonMappedWithExtraAnnotation {
    private final Long someLong;

    private ImmutableJacksonMappedWithExtraAnnotation(Long someLong) {
        this.someLong = someLong;
    }

    @Override
    @AdditionalJacksonAnnotation(value="some_long")
    @JsonProperty(value="some_long_string")
    @JsonSerialize(using=ToStringSerializer.class)
    public Long getSomeLong() {
        return this.someLong;
    }

    public final ImmutableJacksonMappedWithExtraAnnotation withSomeLong(Long value) {
        if (this.someLong.equals(value)) {
            return this;
        }
        return new ImmutableJacksonMappedWithExtraAnnotation((Long)Preconditions.checkNotNull((Object)value, (Object)"someLong"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJacksonMappedWithExtraAnnotation && this.equalTo((ImmutableJacksonMappedWithExtraAnnotation)another);
    }

    private boolean equalTo(ImmutableJacksonMappedWithExtraAnnotation another) {
        return this.someLong.equals(another.someLong);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.someLong.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JacksonMappedWithExtraAnnotation").add("someLong", (Object)this.someLong).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableJacksonMappedWithExtraAnnotation fromJson(Json json) {
        Builder builder = ImmutableJacksonMappedWithExtraAnnotation.builder();
        if (json.someLong != null) {
            builder.someLong(json.someLong);
        }
        return builder.build();
    }

    public static ImmutableJacksonMappedWithExtraAnnotation copyOf(JacksonMappedWithExtraAnnotation instance) {
        if (instance instanceof ImmutableJacksonMappedWithExtraAnnotation) {
            return (ImmutableJacksonMappedWithExtraAnnotation)instance;
        }
        return ImmutableJacksonMappedWithExtraAnnotation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOME_LONG = 1L;
        private long initBits = 1L;
        @Nullable
        private Long someLong;

        private Builder() {
        }

        public final Builder from(JacksonMappedWithExtraAnnotation instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.someLong(instance.getSomeLong());
            return this;
        }

        public final Builder someLong(Long someLong) {
            this.someLong = (Long)Preconditions.checkNotNull((Object)someLong, (Object)"someLong");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableJacksonMappedWithExtraAnnotation build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJacksonMappedWithExtraAnnotation(this.someLong);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("someLong");
            }
            return "Cannot build JacksonMappedWithExtraAnnotation, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    implements JacksonMappedWithExtraAnnotation {
        @Nullable
        Long someLong;

        Json() {
        }

        @AdditionalJacksonAnnotation(value="some_long")
        @JsonProperty(value="some_long_string")
        @JsonSerialize(using=ToStringSerializer.class)
        public void setSomeLong(Long someLong) {
            this.someLong = someLong;
        }

        @Override
        public Long getSomeLong() {
            throw new UnsupportedOperationException();
        }
    }
}

