/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.JacksonMappedWithNoAnnotations;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableJacksonMappedWithNoAnnotations
implements JacksonMappedWithNoAnnotations {
    private final String someString;

    private ImmutableJacksonMappedWithNoAnnotations(String someString) {
        this.someString = someString;
    }

    @Override
    @JsonProperty
    public String getSomeString() {
        return this.someString;
    }

    public final ImmutableJacksonMappedWithNoAnnotations withSomeString(String value) {
        if (this.someString.equals(value)) {
            return this;
        }
        return new ImmutableJacksonMappedWithNoAnnotations((String)Preconditions.checkNotNull((Object)value, (Object)"someString"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJacksonMappedWithNoAnnotations && this.equalTo((ImmutableJacksonMappedWithNoAnnotations)another);
    }

    private boolean equalTo(ImmutableJacksonMappedWithNoAnnotations another) {
        return this.someString.equals(another.someString);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.someString.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JacksonMappedWithNoAnnotations").add("someString", (Object)this.someString).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableJacksonMappedWithNoAnnotations fromJson(Json json) {
        Builder builder = ImmutableJacksonMappedWithNoAnnotations.builder();
        if (json.someString != null) {
            builder.someString(json.someString);
        }
        return builder.build();
    }

    public static ImmutableJacksonMappedWithNoAnnotations copyOf(JacksonMappedWithNoAnnotations instance) {
        if (instance instanceof ImmutableJacksonMappedWithNoAnnotations) {
            return (ImmutableJacksonMappedWithNoAnnotations)instance;
        }
        return ImmutableJacksonMappedWithNoAnnotations.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SOME_STRING = 1L;
        private long initBits = 1L;
        @Nullable
        private String someString;

        private Builder() {
        }

        public final Builder from(JacksonMappedWithNoAnnotations instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.someString(instance.getSomeString());
            return this;
        }

        public final Builder someString(String someString) {
            this.someString = (String)Preconditions.checkNotNull((Object)someString, (Object)"someString");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableJacksonMappedWithNoAnnotations build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJacksonMappedWithNoAnnotations(this.someString);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("someString");
            }
            return "Cannot build JacksonMappedWithNoAnnotations, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    static final class Json
    implements JacksonMappedWithNoAnnotations {
        @Nullable
        String someString;

        Json() {
        }

        @JsonProperty
        public void setSomeString(String someString) {
            this.someString = someString;
        }

        @Override
        public String getSomeString() {
            throw new UnsupportedOperationException();
        }
    }
}

