/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.LazyAttributesSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableLazyAttributesSafe
extends LazyAttributesSafe {
    private final int a;
    private final String derived;
    private final int defaults;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private volatile long lazyInitBitmap;
    private static final long LAZY_LAZY_INIT_BIT = 1L;
    private String lazy;

    private ImmutableLazyAttributesSafe(Builder builder) {
        this.a = builder.a;
        if (builder.defaultsIsSet()) {
            this.initShim.defaults(builder.defaults);
        }
        this.defaults = this.initShim.getDefaults();
        this.derived = this.initShim.getDerived();
        this.initShim = null;
    }

    private ImmutableLazyAttributesSafe(int a, int defaults) {
        this.a = a;
        this.defaults = defaults;
        this.initShim.defaults(defaults);
        this.derived = this.initShim.getDerived();
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public int getA() {
        return this.a;
    }

    @Override
    @JsonProperty
    public String getDerived() {
        return this.initShim != null ? this.initShim.getDerived() : this.derived;
    }

    @Override
    @JsonProperty
    public int getDefaults() {
        return this.initShim != null ? this.initShim.getDefaults() : this.defaults;
    }

    public final ImmutableLazyAttributesSafe withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableLazyAttributesSafe(value, this.defaults);
    }

    public final ImmutableLazyAttributesSafe withDefaults(int value) {
        if (this.defaults == value) {
            return this;
        }
        return new ImmutableLazyAttributesSafe(this.a, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLazyAttributesSafe && this.equalTo((ImmutableLazyAttributesSafe)another);
    }

    private boolean equalTo(ImmutableLazyAttributesSafe another) {
        return this.a == another.a && this.derived.equals(another.derived) && this.defaults == another.defaults;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.a;
        h = h * 17 + this.derived.hashCode();
        h = h * 17 + this.defaults;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LazyAttributesSafe").add("a", this.a).add("derived", (Object)this.derived).add("defaults", this.defaults).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableLazyAttributesSafe fromJson(Json json) {
        Builder builder = ImmutableLazyAttributesSafe.builder();
        if (json.a != null) {
            builder.a(json.a);
        }
        if (json.defaults != null) {
            builder.defaults(json.defaults);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLazy() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableLazyAttributesSafe immutableLazyAttributesSafe = this;
            synchronized (immutableLazyAttributesSafe) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.lazy = (String)Preconditions.checkNotNull((Object)super.getLazy(), (Object)"lazy");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.lazy;
    }

    public static ImmutableLazyAttributesSafe copyOf(LazyAttributesSafe instance) {
        if (instance instanceof ImmutableLazyAttributesSafe) {
            return (ImmutableLazyAttributesSafe)instance;
        }
        return ImmutableLazyAttributesSafe.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private static final long OPT_BIT_DEFAULTS = 1L;
        private long initBits = 1L;
        private long optBits;
        private int a;
        private int defaults;

        private Builder() {
        }

        public final Builder from(LazyAttributesSafe instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.a(instance.getA());
            this.defaults(instance.getDefaults());
            return this;
        }

        public final Builder a(int a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder defaults(int defaults) {
            this.defaults = defaults;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableLazyAttributesSafe build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLazyAttributesSafe(this);
        }

        private boolean defaultsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            return "Cannot build LazyAttributesSafe, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends LazyAttributesSafe {
        @Nullable
        Integer a;
        @Nullable
        Integer defaults;

        Json() {
        }

        @JsonProperty
        public void setA(int a) {
            this.a = a;
        }

        @JsonProperty
        public void setDefaults(int defaults) {
            this.defaults = defaults;
        }

        @Override
        public int getA() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDerived() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDefaults() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLazy() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private String derived;
        private byte derivedStage;
        private int defaults;
        private byte defaultsStage;

        private InitShim() {
        }

        String getDerived() {
            if (this.derivedStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.derivedStage == 0) {
                this.derivedStage = (byte)-1;
                this.derived = (String)Preconditions.checkNotNull((Object)ImmutableLazyAttributesSafe.super.getDerived(), (Object)"derived");
                this.derivedStage = 1;
            }
            return this.derived;
        }

        int getDefaults() {
            if (this.defaultsStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultsStage == 0) {
                this.defaultsStage = (byte)-1;
                this.defaults = ImmutableLazyAttributesSafe.super.getDefaults();
                this.defaultsStage = 1;
            }
            return this.defaults;
        }

        int defaults(int value) {
            this.defaults = value;
            this.defaultsStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.derivedStage == -1) {
                attributes.add("derived");
            }
            if (this.defaultsStage == -1) {
                attributes.add("defaults");
            }
            return "Cannot build LazyAttributesSafe, attribute initializers form cycle" + attributes;
        }
    }
}

