/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.MinimumAnnotationsMapped;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableMinimumAnnotationsMapped
implements MinimumAnnotationsMapped {
    private final String a;
    private final ImmutableList<Integer> b;

    private ImmutableMinimumAnnotationsMapped(String a, ImmutableList<Integer> b) {
        this.a = a;
        this.b = b;
    }

    @Override
    @JsonProperty(value="A")
    public String a() {
        return this.a;
    }

    @JsonProperty(value="B")
    public ImmutableList<Integer> b() {
        return this.b;
    }

    public final ImmutableMinimumAnnotationsMapped withA(String value) {
        if (this.a.equals(value)) {
            return this;
        }
        return new ImmutableMinimumAnnotationsMapped((String)Preconditions.checkNotNull((Object)value, (Object)"a"), this.b);
    }

    public final ImmutableMinimumAnnotationsMapped withB(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableMinimumAnnotationsMapped(this.a, (ImmutableList<Integer>)newValue);
    }

    public final ImmutableMinimumAnnotationsMapped withB(Iterable<Integer> elements) {
        if (this.b == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMinimumAnnotationsMapped(this.a, (ImmutableList<Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMinimumAnnotationsMapped && this.equalTo((ImmutableMinimumAnnotationsMapped)another);
    }

    private boolean equalTo(ImmutableMinimumAnnotationsMapped another) {
        return this.a.equals(another.a) && this.b.equals(another.b);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.a.hashCode();
        h = h * 17 + this.b.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MinimumAnnotationsMapped").add("a", (Object)this.a).add("b", this.b).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableMinimumAnnotationsMapped fromJson(Json json) {
        Builder builder = ImmutableMinimumAnnotationsMapped.builder();
        if (json.a != null) {
            builder.a(json.a);
        }
        if (json.b != null) {
            builder.addAllB(json.b);
        }
        return builder.build();
    }

    public static ImmutableMinimumAnnotationsMapped copyOf(MinimumAnnotationsMapped instance) {
        if (instance instanceof ImmutableMinimumAnnotationsMapped) {
            return (ImmutableMinimumAnnotationsMapped)instance;
        }
        return ImmutableMinimumAnnotationsMapped.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private long initBits = 1L;
        @Nullable
        private String a;
        private ImmutableList.Builder<Integer> bBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(MinimumAnnotationsMapped instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.a(instance.a());
            this.addAllB(instance.b());
            return this;
        }

        public final Builder a(String a) {
            this.a = (String)Preconditions.checkNotNull((Object)a, (Object)"a");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addB(int element) {
            this.bBuilder.add((Object)element);
            return this;
        }

        public final Builder addB(int ... elements) {
            this.bBuilder.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        public final Builder b(Iterable<Integer> elements) {
            this.bBuilder = ImmutableList.builder();
            return this.addAllB(elements);
        }

        public final Builder addAllB(Iterable<Integer> elements) {
            this.bBuilder.addAll(elements);
            return this;
        }

        public ImmutableMinimumAnnotationsMapped build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMinimumAnnotationsMapped(this.a, this.bBuilder.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            return "Cannot build MinimumAnnotationsMapped, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    implements MinimumAnnotationsMapped {
        @Nullable
        String a;
        List<Integer> b = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="A")
        public void setA(String a) {
            this.a = a;
        }

        @JsonProperty(value="B")
        public void setB(List<Integer> b) {
            this.b = b;
        }

        @Override
        public String a() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Integer> b() {
            throw new UnsupportedOperationException();
        }
    }
}

