/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.fixture.jackson.NoBuilderDeserialize;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableNoBuilderDeserialize
extends NoBuilderDeserialize {
    private final ImmutableList<String> prop;
    private static final ImmutableNoBuilderDeserialize INSTANCE = ImmutableNoBuilderDeserialize.validate(new ImmutableNoBuilderDeserialize());

    private ImmutableNoBuilderDeserialize() {
        this.prop = ImmutableList.of();
    }

    private ImmutableNoBuilderDeserialize(ImmutableList<String> prop) {
        this.prop = prop;
    }

    @JsonProperty
    public ImmutableList<String> prop() {
        return this.prop;
    }

    public final ImmutableNoBuilderDeserialize withProp(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableNoBuilderDeserialize.validate(new ImmutableNoBuilderDeserialize((ImmutableList<String>)newValue));
    }

    public final ImmutableNoBuilderDeserialize withProp(Iterable<String> elements) {
        if (this.prop == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableNoBuilderDeserialize.validate(new ImmutableNoBuilderDeserialize((ImmutableList<String>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNoBuilderDeserialize && this.equalTo((ImmutableNoBuilderDeserialize)another);
    }

    private boolean equalTo(ImmutableNoBuilderDeserialize another) {
        return this.prop.equals(another.prop);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.prop.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NoBuilderDeserialize").add("prop", this.prop).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableNoBuilderDeserialize fromJson(Json json) {
        ImmutableNoBuilderDeserialize instance = ImmutableNoBuilderDeserialize.instance();
        if (json.prop != null) {
            instance = instance.withProp(json.prop);
        }
        return instance;
    }

    public static ImmutableNoBuilderDeserialize instance() {
        return INSTANCE;
    }

    private static ImmutableNoBuilderDeserialize validate(ImmutableNoBuilderDeserialize instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends NoBuilderDeserialize {
        List<String> prop = ImmutableList.of();

        Json() {
        }

        @JsonProperty
        public void setProp(List<String> prop) {
            this.prop = prop;
        }

        @Override
        public List<String> prop() {
            throw new UnsupportedOperationException();
        }
    }
}

