/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.Inherited;
import org.immutables.fixture.jackson.OptionIncludeNonEmpty;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableOptionIncludeNonEmpty
extends OptionIncludeNonEmpty {
    private final Optional<String> relationships;
    private final ImmutableMap<String, Number> map;
    @Nullable
    private final Integer integer;

    private ImmutableOptionIncludeNonEmpty(Optional<String> relationships, ImmutableMap<String, Number> map, @Nullable Integer integer) {
        this.relationships = relationships;
        this.map = map;
        this.integer = integer;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Optional<String> getRelationships() {
        return this.relationships;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableMap<String, Number> getMap() {
        return this.map;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Integer getInteger() {
        return this.integer;
    }

    public final ImmutableOptionIncludeNonEmpty withRelationships(String value) {
        Optional newValue = Optional.of((Object)value);
        return new ImmutableOptionIncludeNonEmpty((Optional<String>)newValue, this.map, this.integer);
    }

    @Override
    public final ImmutableOptionIncludeNonEmpty withRelationships(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"relationships");
        if (this.relationships == value) {
            return this;
        }
        return new ImmutableOptionIncludeNonEmpty((Optional<String>)value, this.map, this.integer);
    }

    @Override
    public final ImmutableOptionIncludeNonEmpty withMap(Map<String, ? extends Number> entries) {
        if (this.map == entries) {
            return this;
        }
        ImmutableMap value = ImmutableMap.copyOf(entries);
        return new ImmutableOptionIncludeNonEmpty(this.relationships, (ImmutableMap<String, Number>)value, this.integer);
    }

    public final ImmutableOptionIncludeNonEmpty withInteger(@Nullable Integer value) {
        if (Objects.equal((Object)this.integer, (Object)value)) {
            return this;
        }
        return new ImmutableOptionIncludeNonEmpty(this.relationships, this.map, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOptionIncludeNonEmpty && this.equalTo((ImmutableOptionIncludeNonEmpty)another);
    }

    private boolean equalTo(ImmutableOptionIncludeNonEmpty another) {
        return this.relationships.equals(another.relationships) && this.map.equals(another.map) && Objects.equal((Object)this.integer, (Object)another.integer);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.relationships.hashCode();
        h = h * 17 + this.map.hashCode();
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.integer});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OptionIncludeNonEmpty").add("relationships", this.relationships).add("map", this.map).add("integer", (Object)this.integer).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableOptionIncludeNonEmpty fromJson(Json json) {
        Builder builder = ImmutableOptionIncludeNonEmpty.builder();
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.map != null) {
            builder.putAllMap(json.map);
        }
        if (json.integer != null) {
            builder.integer(json.integer);
        }
        return builder.build();
    }

    public static ImmutableOptionIncludeNonEmpty copyOf(OptionIncludeNonEmpty instance) {
        if (instance instanceof ImmutableOptionIncludeNonEmpty) {
            return (ImmutableOptionIncludeNonEmpty)instance;
        }
        return ImmutableOptionIncludeNonEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private Optional<String> relationships = Optional.absent();
        private ImmutableMap.Builder<String, Number> mapBuilder = ImmutableMap.builder();
        @Nullable
        private Integer integer;

        private Builder() {
        }

        public final Builder from(OptionIncludeNonEmpty instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Inherited instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Integer integerValue;
            Inherited instance;
            if (object instanceof OptionIncludeNonEmpty) {
                instance = (OptionIncludeNonEmpty)object;
                Optional<String> relationshipsOptional = ((OptionIncludeNonEmpty)instance).getRelationships();
                if (relationshipsOptional.isPresent()) {
                    this.relationships(relationshipsOptional);
                }
                this.putAllMap(((OptionIncludeNonEmpty)instance).getMap());
            }
            if (object instanceof Inherited && (integerValue = (instance = (Inherited)object).getInteger()) != null) {
                this.integer(integerValue);
            }
        }

        public final Builder relationships(String relationships) {
            this.relationships = Optional.of((Object)relationships);
            return this;
        }

        public final Builder relationships(Optional<String> relationships) {
            this.relationships = (Optional)Preconditions.checkNotNull(relationships, (Object)"relationships");
            return this;
        }

        public final Builder putMap(String key, Number value) {
            this.mapBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putMap(Map.Entry<String, ? extends Number> entry) {
            this.mapBuilder.put(entry);
            return this;
        }

        public final Builder map(Map<String, ? extends Number> entries) {
            this.mapBuilder = ImmutableMap.builder();
            return this.putAllMap(entries);
        }

        public final Builder putAllMap(Map<String, ? extends Number> entries) {
            this.mapBuilder.putAll(entries);
            return this;
        }

        public final Builder integer(@Nullable Integer integer) {
            this.integer = integer;
            return this;
        }

        public ImmutableOptionIncludeNonEmpty build() throws IllegalStateException {
            return new ImmutableOptionIncludeNonEmpty(this.relationships, this.mapBuilder.build(), this.integer);
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends OptionIncludeNonEmpty {
        Optional<String> relationships = Optional.absent();
        @Nullable
        Map<String, Number> map;
        @Nullable
        Integer integer;

        Json() {
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setRelationships(Optional<String> relationships) {
            this.relationships = relationships;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setMap(Map<String, Number> map) {
            this.map = map;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setInteger(@Nullable Integer integer) {
            this.integer = integer;
        }

        @Override
        public OptionIncludeNonEmpty withRelationships(Optional<String> number) {
            throw new UnsupportedOperationException();
        }

        @Override
        public OptionIncludeNonEmpty withMap(Map<String, ? extends Number> number) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Number> getMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getInteger() {
            throw new UnsupportedOperationException();
        }
    }
}

