/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.fixture.jackson.OptionIncludeNonEmptyWithConstructor;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableOptionIncludeNonEmptyWithConstructor
extends OptionIncludeNonEmptyWithConstructor {
    private final Optional<String> relationships;

    private ImmutableOptionIncludeNonEmptyWithConstructor(Optional<String> relationships) {
        this.relationships = (Optional)Preconditions.checkNotNull(relationships, (Object)"relationships");
    }

    private ImmutableOptionIncludeNonEmptyWithConstructor(ImmutableOptionIncludeNonEmptyWithConstructor original, Optional<String> relationships) {
        this.relationships = relationships;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Optional<String> getRelationships() {
        return this.relationships;
    }

    public final ImmutableOptionIncludeNonEmptyWithConstructor withRelationships(String value) {
        Optional newValue = Optional.of((Object)value);
        return new ImmutableOptionIncludeNonEmptyWithConstructor(this, (Optional<String>)newValue);
    }

    public final ImmutableOptionIncludeNonEmptyWithConstructor withRelationships(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"relationships");
        if (this.relationships == value) {
            return this;
        }
        return new ImmutableOptionIncludeNonEmptyWithConstructor(this, (Optional<String>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOptionIncludeNonEmptyWithConstructor && this.equalTo((ImmutableOptionIncludeNonEmptyWithConstructor)another);
    }

    private boolean equalTo(ImmutableOptionIncludeNonEmptyWithConstructor another) {
        return this.relationships.equals(another.relationships);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.relationships.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OptionIncludeNonEmptyWithConstructor").add("relationships", this.relationships).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableOptionIncludeNonEmptyWithConstructor fromJson(Json json) {
        ImmutableOptionIncludeNonEmptyWithConstructor instance = ImmutableOptionIncludeNonEmptyWithConstructor.of(json.relationships);
        return instance;
    }

    public static ImmutableOptionIncludeNonEmptyWithConstructor of(Optional<String> relationships) {
        return new ImmutableOptionIncludeNonEmptyWithConstructor(relationships);
    }

    public static ImmutableOptionIncludeNonEmptyWithConstructor copyOf(OptionIncludeNonEmptyWithConstructor instance) {
        if (instance instanceof ImmutableOptionIncludeNonEmptyWithConstructor) {
            return (ImmutableOptionIncludeNonEmptyWithConstructor)instance;
        }
        return ImmutableOptionIncludeNonEmptyWithConstructor.of(instance.getRelationships());
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends OptionIncludeNonEmptyWithConstructor {
        Optional<String> relationships = Optional.absent();

        Json() {
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setRelationships(Optional<String> relationships) {
            this.relationships = relationships;
        }

        @Override
        public Optional<String> getRelationships() {
            throw new UnsupportedOperationException();
        }
    }
}

