/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.fixture.jackson.PackageNoBuilderHidden;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutablePackageNoBuilderHidden
implements PackageNoBuilderHidden {
    private final List<String> strings;
    @Nullable
    private final Integer getInt;
    private static final ImmutablePackageNoBuilderHidden INSTANCE = ImmutablePackageNoBuilderHidden.validate(new ImmutablePackageNoBuilderHidden());

    private ImmutablePackageNoBuilderHidden() {
        this.strings = Collections.emptyList();
        this.getInt = null;
    }

    private ImmutablePackageNoBuilderHidden(List<String> strings, @Nullable Integer getInt) {
        this.strings = strings;
        this.getInt = getInt;
    }

    @Override
    @JsonProperty
    public List<String> getStrings() {
        return this.strings;
    }

    @Override
    @JsonProperty
    public Optional<Integer> getInt() {
        return Optional.ofNullable(this.getInt);
    }

    public final ImmutablePackageNoBuilderHidden withStrings(String ... elements) {
        List<String> newValue = ImmutablePackageNoBuilderHidden.createUnmodifiableList(false, ImmutablePackageNoBuilderHidden.createSafeList(Arrays.asList(elements)));
        return ImmutablePackageNoBuilderHidden.validate(new ImmutablePackageNoBuilderHidden(newValue, this.getInt));
    }

    public final ImmutablePackageNoBuilderHidden withStrings(Iterable<String> elements) {
        if (this.strings == elements) {
            return this;
        }
        List<String> newValue = ImmutablePackageNoBuilderHidden.createUnmodifiableList(false, ImmutablePackageNoBuilderHidden.createSafeList(elements));
        return ImmutablePackageNoBuilderHidden.validate(new ImmutablePackageNoBuilderHidden(newValue, this.getInt));
    }

    public final ImmutablePackageNoBuilderHidden withGetInt(int value) {
        Integer newValue = value;
        if (this.getInt == newValue) {
            return this;
        }
        return ImmutablePackageNoBuilderHidden.validate(new ImmutablePackageNoBuilderHidden(this.strings, newValue));
    }

    public final ImmutablePackageNoBuilderHidden withGetInt(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (this.getInt == value) {
            return this;
        }
        return ImmutablePackageNoBuilderHidden.validate(new ImmutablePackageNoBuilderHidden(this.strings, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePackageNoBuilderHidden && this.equalTo((ImmutablePackageNoBuilderHidden)another);
    }

    private boolean equalTo(ImmutablePackageNoBuilderHidden another) {
        return this.strings.equals(another.strings) && Objects.equals(this.getInt, another.getInt);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.strings.hashCode();
        h = h * 17 + Objects.hashCode(this.getInt);
        return h;
    }

    public String toString() {
        return "PackageNoBuilderHidden{strings=" + this.strings + ", getInt=" + this.getInt() + "}";
    }

    @Deprecated
    @JsonCreator
    static ImmutablePackageNoBuilderHidden fromJson(Json json) {
        ImmutablePackageNoBuilderHidden instance = (ImmutablePackageNoBuilderHidden)ImmutablePackageNoBuilderHidden.of();
        if (json.strings != null) {
            instance = instance.withStrings(json.strings);
        }
        if (json.getInt != null) {
            instance = instance.withGetInt(json.getInt);
        }
        return instance;
    }

    public static PackageNoBuilderHidden of() {
        return INSTANCE;
    }

    private static ImmutablePackageNoBuilderHidden validate(ImmutablePackageNoBuilderHidden instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    private static <T> ArrayList<T> createSafeList(Iterable<? extends T> iterable) {
        ArrayList<T> list = iterable instanceof Collection ? new ArrayList<T>(((Collection)iterable).size()) : new ArrayList();
        for (T element : iterable) {
            list.add(Objects.requireNonNull(element, "element"));
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    implements PackageNoBuilderHidden {
        List<String> strings = Collections.emptyList();
        Optional<Integer> getInt = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setStrings(List<String> strings) {
            this.strings = strings;
        }

        @JsonProperty
        public void setGetInt(Optional<Integer> getInt) {
            this.getInt = getInt;
        }

        @Override
        public List<String> getStrings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getInt() {
            throw new UnsupportedOperationException();
        }
    }
}

