/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.SampleJacksonMapped;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSampleJacksonMapped
implements SampleJacksonMapped {
    private final String a;
    private final ImmutableList<Integer> b;
    private final Optional<SampleJacksonMapped.RegularPojo> pojo;

    private ImmutableSampleJacksonMapped(String a, ImmutableList<Integer> b, Optional<SampleJacksonMapped.RegularPojo> pojo) {
        this.a = a;
        this.b = b;
        this.pojo = pojo;
    }

    @Override
    @JsonProperty
    public String a() {
        return this.a;
    }

    @JsonProperty
    public ImmutableList<Integer> b() {
        return this.b;
    }

    @Override
    @JsonProperty
    public Optional<SampleJacksonMapped.RegularPojo> pojo() {
        return this.pojo;
    }

    public final ImmutableSampleJacksonMapped withA(String value) {
        if (this.a.equals(value)) {
            return this;
        }
        return new ImmutableSampleJacksonMapped((String)Preconditions.checkNotNull((Object)value, (Object)"a"), this.b, this.pojo);
    }

    public final ImmutableSampleJacksonMapped withB(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableSampleJacksonMapped(this.a, (ImmutableList<Integer>)newValue, this.pojo);
    }

    public final ImmutableSampleJacksonMapped withB(Iterable<Integer> elements) {
        if (this.b == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSampleJacksonMapped(this.a, (ImmutableList<Integer>)newValue, this.pojo);
    }

    public final ImmutableSampleJacksonMapped withPojo(SampleJacksonMapped.RegularPojo value) {
        Optional newValue = Optional.of((Object)value);
        return new ImmutableSampleJacksonMapped(this.a, this.b, (Optional<SampleJacksonMapped.RegularPojo>)newValue);
    }

    public final ImmutableSampleJacksonMapped withPojo(Optional<SampleJacksonMapped.RegularPojo> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"pojo");
        if (this.pojo == value) {
            return this;
        }
        return new ImmutableSampleJacksonMapped(this.a, this.b, (Optional<SampleJacksonMapped.RegularPojo>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSampleJacksonMapped && this.equalTo((ImmutableSampleJacksonMapped)another);
    }

    private boolean equalTo(ImmutableSampleJacksonMapped another) {
        return this.a.equals(another.a) && this.b.equals(another.b) && this.pojo.equals(another.pojo);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.a.hashCode();
        h = h * 17 + this.b.hashCode();
        h = h * 17 + this.pojo.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SampleJacksonMapped").add("a", (Object)this.a).add("b", this.b).add("pojo", this.pojo).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableSampleJacksonMapped fromJson(Json json) {
        Builder builder = ImmutableSampleJacksonMapped.builder();
        if (json.a != null) {
            builder.a(json.a);
        }
        if (json.b != null) {
            builder.addAllB(json.b);
        }
        if (json.pojo != null) {
            builder.pojo(json.pojo);
        }
        return builder.build();
    }

    public static ImmutableSampleJacksonMapped copyOf(SampleJacksonMapped instance) {
        if (instance instanceof ImmutableSampleJacksonMapped) {
            return (ImmutableSampleJacksonMapped)instance;
        }
        return ImmutableSampleJacksonMapped.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private long initBits = 1L;
        @Nullable
        private String a;
        private ImmutableList.Builder<Integer> bBuilder = ImmutableList.builder();
        private Optional<SampleJacksonMapped.RegularPojo> pojo = Optional.absent();

        private Builder() {
        }

        public final Builder from(SampleJacksonMapped instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.a(instance.a());
            this.addAllB(instance.b());
            Optional<SampleJacksonMapped.RegularPojo> pojoOptional = instance.pojo();
            if (pojoOptional.isPresent()) {
                this.pojo(pojoOptional);
            }
            return this;
        }

        public final Builder a(String a) {
            this.a = (String)Preconditions.checkNotNull((Object)a, (Object)"a");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addB(int element) {
            this.bBuilder.add((Object)element);
            return this;
        }

        public final Builder addB(int ... elements) {
            this.bBuilder.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        public final Builder b(Iterable<Integer> elements) {
            this.bBuilder = ImmutableList.builder();
            return this.addAllB(elements);
        }

        public final Builder addAllB(Iterable<Integer> elements) {
            this.bBuilder.addAll(elements);
            return this;
        }

        public final Builder pojo(SampleJacksonMapped.RegularPojo pojo) {
            this.pojo = Optional.of((Object)pojo);
            return this;
        }

        public final Builder pojo(Optional<SampleJacksonMapped.RegularPojo> pojo) {
            this.pojo = (Optional)Preconditions.checkNotNull(pojo, (Object)"pojo");
            return this;
        }

        public ImmutableSampleJacksonMapped build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSampleJacksonMapped(this.a, this.bBuilder.build(), this.pojo);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            return "Cannot build SampleJacksonMapped, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    implements SampleJacksonMapped {
        @Nullable
        String a;
        List<Integer> b = ImmutableList.of();
        Optional<SampleJacksonMapped.RegularPojo> pojo = Optional.absent();

        Json() {
        }

        @JsonProperty
        public void setA(String a) {
            this.a = a;
        }

        @JsonProperty
        public void setB(List<Integer> b) {
            this.b = b;
        }

        @JsonProperty
        public void setPojo(Optional<SampleJacksonMapped.RegularPojo> pojo) {
            this.pojo = pojo;
        }

        @Override
        public String a() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Integer> b() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SampleJacksonMapped.RegularPojo> pojo() {
            throw new UnsupportedOperationException();
        }
    }
}

