/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.PackageHidden;

@ParametersAreNonnullByDefault
@NotThreadSafe
public final class PackageHiddenBuilder {
    private ArrayList<String> stringsBuilder = new ArrayList();

    public final PackageHiddenBuilder from(PackageHidden instance) {
        Objects.requireNonNull(instance, "instance");
        this.addAllStrings(instance.getStrings());
        return this;
    }

    public final PackageHiddenBuilder addStrings(String element) {
        this.stringsBuilder.add(Objects.requireNonNull(element, "strings element"));
        return this;
    }

    public final PackageHiddenBuilder addStrings(String ... elements) {
        for (String element : elements) {
            this.stringsBuilder.add(Objects.requireNonNull(element, "strings element"));
        }
        return this;
    }

    public final PackageHiddenBuilder strings(Iterable<String> elements) {
        this.stringsBuilder.clear();
        return this.addAllStrings(elements);
    }

    public final PackageHiddenBuilder addAllStrings(Iterable<String> elements) {
        for (String element : elements) {
            this.stringsBuilder.add(Objects.requireNonNull(element, "strings element"));
        }
        return this;
    }

    public PackageHidden build() throws IllegalStateException {
        return new ImmutablePackageHidden(PackageHiddenBuilder.createUnmodifiableList(true, this.stringsBuilder));
    }

    private static <T> ArrayList<T> createSafeList(Iterable<? extends T> iterable) {
        ArrayList<T> list = iterable instanceof Collection ? new ArrayList<T>(((Collection)iterable).size()) : new ArrayList();
        for (T element : iterable) {
            list.add(Objects.requireNonNull(element, "element"));
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Immutable
    static final class ImmutablePackageHidden
    implements PackageHidden {
        private final List<String> strings;

        private ImmutablePackageHidden(List<String> strings) {
            this.strings = strings;
        }

        @Override
        @JsonProperty
        public List<String> getStrings() {
            return this.strings;
        }

        public final ImmutablePackageHidden withStrings(String ... elements) {
            List newValue = PackageHiddenBuilder.createUnmodifiableList(false, PackageHiddenBuilder.createSafeList(Arrays.asList(elements)));
            return new ImmutablePackageHidden(newValue);
        }

        public final ImmutablePackageHidden withStrings(Iterable<String> elements) {
            if (this.strings == elements) {
                return this;
            }
            List newValue = PackageHiddenBuilder.createUnmodifiableList(false, PackageHiddenBuilder.createSafeList(elements));
            return new ImmutablePackageHidden(newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutablePackageHidden && this.equalTo((ImmutablePackageHidden)another);
        }

        private boolean equalTo(ImmutablePackageHidden another) {
            return this.strings.equals(another.strings);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.strings.hashCode();
            return h;
        }

        public String toString() {
            return "PackageHidden{strings=" + this.strings + "}";
        }

        @Deprecated
        @JsonCreator
        static ImmutablePackageHidden fromJson(Json json) {
            PackageHiddenBuilder builder = new PackageHiddenBuilder();
            if (json.strings != null) {
                builder.addAllStrings(json.strings);
            }
            return (ImmutablePackageHidden)builder.build();
        }

        public static PackageHidden copyOf(PackageHidden instance) {
            if (instance instanceof ImmutablePackageHidden) {
                return (ImmutablePackageHidden)instance;
            }
            return new PackageHiddenBuilder().from(instance).build();
        }

        @Deprecated
        @JsonDeserialize
        static final class Json
        implements PackageHidden {
            List<String> strings = Collections.emptyList();

            Json() {
            }

            @JsonProperty
            public void setStrings(List<String> strings) {
                this.strings = strings;
            }

            @Override
            public List<String> getStrings() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

