/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jdkonly;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.jdkonly.ImmutableUsingAllOptionals;
import org.immutables.fixture.jdkonly.UsingAllOptionals;

@ParametersAreNonnullByDefault
public final class GsonAdaptersUsingAllOptionals
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (UsingAllOptionalsTypeAdapter.adapts(type)) {
            return new UsingAllOptionalsTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersUsingAllOptionals(UsingAllOptionals)";
    }

    private static class UsingAllOptionalsTypeAdapter
    extends TypeAdapter<UsingAllOptionals> {
        private static final TypeToken<UsingAllOptionals> USING_ALL_OPTIONALS_ABSTRACT = TypeToken.get(UsingAllOptionals.class);
        private static final TypeToken<ImmutableUsingAllOptionals> USING_ALL_OPTIONALS_IMMUTABLE = TypeToken.get(ImmutableUsingAllOptionals.class);

        UsingAllOptionalsTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return USING_ALL_OPTIONALS_ABSTRACT.equals(type) || USING_ALL_OPTIONALS_IMMUTABLE.equals(type);
        }

        public void write(JsonWriter out, UsingAllOptionals value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeUsingAllOptionals(out, value);
            }
        }

        public UsingAllOptionals read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readUsingAllOptionals(in);
        }

        private void writeUsingAllOptionals(JsonWriter out, UsingAllOptionals instance) throws IOException {
            out.beginObject();
            com.google.common.base.Optional<Integer> v1Optional = instance.v1();
            if (v1Optional.isPresent()) {
                out.name("v1");
                int v1Value = (Integer)v1Optional.get();
                out.value((long)v1Value);
            } else if (out.getSerializeNulls()) {
                out.name("v1");
                out.nullValue();
            }
            Optional<Integer> v2Optional = instance.v2();
            if (v2Optional.isPresent()) {
                out.name("v2");
                int v2Value = v2Optional.get();
                out.value((long)v2Value);
            } else if (out.getSerializeNulls()) {
                out.name("v2");
                out.nullValue();
            }
            OptionalInt i1Optional = instance.i1();
            if (i1Optional.isPresent()) {
                out.name("i1");
                int i1Value = i1Optional.getAsInt();
                out.value((long)i1Value);
            } else if (out.getSerializeNulls()) {
                out.name("i1");
                out.nullValue();
            }
            OptionalLong l1Optional = instance.l1();
            if (l1Optional.isPresent()) {
                out.name("l1");
                long l1Value = l1Optional.getAsLong();
                out.value(l1Value);
            } else if (out.getSerializeNulls()) {
                out.name("l1");
                out.nullValue();
            }
            OptionalDouble d1Optional = instance.d1();
            if (d1Optional.isPresent()) {
                out.name("d1");
                double d1Value = d1Optional.getAsDouble();
                out.value(d1Value);
            } else if (out.getSerializeNulls()) {
                out.name("d1");
                out.nullValue();
            }
            com.atlassian.fugue.Option<String> fo2Optional = instance.fo2();
            if (fo2Optional.isDefined()) {
                out.name("fo2");
                String fo2Value = (String)fo2Optional.get();
                out.value(fo2Value);
            } else if (out.getSerializeNulls()) {
                out.name("fo2");
                out.nullValue();
            }
            Option<String> fo3Optional = instance.fo3();
            if (fo3Optional.isDefined()) {
                out.name("fo3");
                String fo3Value = (String)fo3Optional.get();
                out.value(fo3Value);
            } else if (out.getSerializeNulls()) {
                out.name("fo3");
                out.nullValue();
            }
            out.endObject();
        }

        private UsingAllOptionals readUsingAllOptionals(JsonReader in) throws IOException {
            ImmutableUsingAllOptionals.Builder builder = ImmutableUsingAllOptionals.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'v': {
                    if ("v1".equals(attributeName)) {
                        this.readInV1(in, builder);
                        return;
                    }
                    if (!"v2".equals(attributeName)) break;
                    this.readInV2(in, builder);
                    return;
                }
                case 'i': {
                    if (!"i1".equals(attributeName)) break;
                    this.readInI1(in, builder);
                    return;
                }
                case 'l': {
                    if (!"l1".equals(attributeName)) break;
                    this.readInL1(in, builder);
                    return;
                }
                case 'd': {
                    if (!"d1".equals(attributeName)) break;
                    this.readInD1(in, builder);
                    return;
                }
                case 'f': {
                    if ("fo2".equals(attributeName)) {
                        this.readInFo2(in, builder);
                        return;
                    }
                    if (!"fo3".equals(attributeName)) break;
                    this.readInFo3(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInV1(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.v1(in.nextInt());
            }
        }

        private void readInV2(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.v2(in.nextInt());
            }
        }

        private void readInI1(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.i1(in.nextInt());
            }
        }

        private void readInL1(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.l1(in.nextLong());
            }
        }

        private void readInD1(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.d1(in.nextDouble());
            }
        }

        private void readInFo2(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.fo2(in.nextString());
            }
        }

        private void readInFo3(JsonReader in, ImmutableUsingAllOptionals.Builder builder) throws IOException {
            JsonToken t = in.peek();
            if (t == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.fo3(in.nextString());
            }
        }
    }
}

