/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jdkonly;

import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jdkonly.JdkColl;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableJdkColl
implements JdkColl {
    private final List<String> str;
    private final Set<Integer> ints;
    private final SortedSet<Integer> ords;
    private final Set<RetentionPolicy> pols;
    private final NavigableSet<Integer> navs;
    private static final ImmutableJdkColl INSTANCE = ImmutableJdkColl.validate(new ImmutableJdkColl());

    private ImmutableJdkColl() {
        this.str = Collections.emptyList();
        this.ints = Collections.emptySet();
        this.ords = ImmutableJdkColl.createUnmodifiableSortedSet(false, Collections.emptyList());
        this.pols = Collections.emptySet();
        this.navs = ImmutableJdkColl.createUnmodifiableSortedSet(true, Collections.emptyList());
    }

    private ImmutableJdkColl(List<String> str, Set<Integer> ints, SortedSet<Integer> ords, Set<RetentionPolicy> pols, NavigableSet<Integer> navs) {
        this.str = str;
        this.ints = ints;
        this.ords = ords;
        this.pols = pols;
        this.navs = navs;
    }

    @Override
    public List<String> str() {
        return this.str;
    }

    @Override
    public Set<Integer> ints() {
        return this.ints;
    }

    @Override
    public SortedSet<Integer> ords() {
        return this.ords;
    }

    @Override
    public Set<RetentionPolicy> pols() {
        return this.pols;
    }

    @Override
    public NavigableSet<Integer> navs() {
        return this.navs;
    }

    public final ImmutableJdkColl withStr(String ... elements) {
        List<String> newValue = ImmutableJdkColl.createUnmodifiableList(false, ImmutableJdkColl.createSafeList(Arrays.asList(elements)));
        return ImmutableJdkColl.validate(new ImmutableJdkColl(newValue, this.ints, this.ords, this.pols, this.navs));
    }

    public final ImmutableJdkColl withStr(Iterable<String> elements) {
        if (this.str == elements) {
            return this;
        }
        List<String> newValue = ImmutableJdkColl.createUnmodifiableList(false, ImmutableJdkColl.createSafeList(elements));
        return ImmutableJdkColl.validate(new ImmutableJdkColl(newValue, this.ints, this.ords, this.pols, this.navs));
    }

    public final ImmutableJdkColl withInts(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        Set<Integer> newValue = ImmutableJdkColl.createUnmodifiableSet(wrappedList);
        return ImmutableJdkColl.validate(new ImmutableJdkColl(this.str, newValue, this.ords, this.pols, this.navs));
    }

    public final ImmutableJdkColl withInts(Iterable<Integer> elements) {
        if (this.ints == elements) {
            return this;
        }
        Set<Integer> newValue = ImmutableJdkColl.createUnmodifiableSet(ImmutableJdkColl.createSafeList(elements));
        return ImmutableJdkColl.validate(new ImmutableJdkColl(this.str, newValue, this.ords, this.pols, this.navs));
    }

    public final ImmutableJdkColl withOrds(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        NavigableSet<Integer> newValue = ImmutableJdkColl.createUnmodifiableSortedSet(false, wrappedList);
        return ImmutableJdkColl.validate(new ImmutableJdkColl(this.str, this.ints, newValue, this.pols, this.navs));
    }

    public final ImmutableJdkColl withOrds(Iterable<Integer> elements) {
        if (this.ords == elements) {
            return this;
        }
        NavigableSet<Integer> newValue = ImmutableJdkColl.createUnmodifiableSortedSet(false, ImmutableJdkColl.createSafeList(elements));
        return ImmutableJdkColl.validate(new ImmutableJdkColl(this.str, this.ints, newValue, this.pols, this.navs));
    }

    public final ImmutableJdkColl withPols(RetentionPolicy ... elements) {
        Set<RetentionPolicy> newValue = ImmutableJdkColl.createUnmodifiableEnumSet(Arrays.asList(elements));
        return ImmutableJdkColl.validate(new ImmutableJdkColl(this.str, this.ints, this.ords, newValue, this.navs));
    }

    public final ImmutableJdkColl withPols(Iterable<RetentionPolicy> elements) {
        if (this.pols == elements) {
            return this;
        }
        Set<RetentionPolicy> newValue = ImmutableJdkColl.createUnmodifiableEnumSet(elements);
        return ImmutableJdkColl.validate(new ImmutableJdkColl(this.str, this.ints, this.ords, newValue, this.navs));
    }

    public final ImmutableJdkColl withNavs(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        NavigableSet<Integer> newValue = ImmutableJdkColl.createUnmodifiableSortedSet(true, wrappedList);
        return ImmutableJdkColl.validate(new ImmutableJdkColl(this.str, this.ints, this.ords, this.pols, newValue));
    }

    public final ImmutableJdkColl withNavs(Iterable<Integer> elements) {
        if (this.navs == elements) {
            return this;
        }
        NavigableSet<Integer> newValue = ImmutableJdkColl.createUnmodifiableSortedSet(true, ImmutableJdkColl.createSafeList(elements));
        return ImmutableJdkColl.validate(new ImmutableJdkColl(this.str, this.ints, this.ords, this.pols, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJdkColl && this.equalTo((ImmutableJdkColl)another);
    }

    private boolean equalTo(ImmutableJdkColl another) {
        return this.str.equals(another.str) && this.ints.equals(another.ints) && this.ords.equals(another.ords) && this.pols.equals(another.pols) && this.navs.equals(another.navs);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.str.hashCode();
        h = h * 17 + this.ints.hashCode();
        h = h * 17 + this.ords.hashCode();
        h = h * 17 + this.pols.hashCode();
        h = h * 17 + this.navs.hashCode();
        return h;
    }

    public String toString() {
        return "JdkColl{str=" + this.str + ", ints=" + this.ints + ", ords=" + this.ords + ", pols=" + this.pols + ", navs=" + this.navs + "}";
    }

    public static ImmutableJdkColl of() {
        return INSTANCE;
    }

    private static ImmutableJdkColl validate(ImmutableJdkColl instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static ImmutableJdkColl copyOf(JdkColl instance) {
        if (instance instanceof ImmutableJdkColl) {
            return (ImmutableJdkColl)instance;
        }
        return ImmutableJdkColl.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> ArrayList<T> createSafeList(Iterable<? extends T> iterable) {
        ArrayList<T> list = iterable instanceof Collection ? new ArrayList<T>(((Collection)iterable).size()) : new ArrayList();
        for (T element : iterable) {
            list.add(Objects.requireNonNull(element, "element"));
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        ArrayList<T> list = ImmutableJdkColl.createSafeList(iterable);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    private static <T extends Comparable<T>> NavigableSet<T> createUnmodifiableSortedSet(boolean reverse, List<T> list) {
        TreeSet set = reverse ? new TreeSet(Collections.reverseOrder()) : new TreeSet();
        set.addAll(list);
        return Collections.unmodifiableNavigableSet(set);
    }

    @NotThreadSafe
    public static final class Builder {
        private ArrayList<String> strBuilder = new ArrayList();
        private ArrayList<Integer> intsBuilder = new ArrayList();
        private ArrayList<Integer> ordsBuilder = new ArrayList();
        private EnumSet<RetentionPolicy> polsBuilder = EnumSet.noneOf(RetentionPolicy.class);
        private ArrayList<Integer> navsBuilder = new ArrayList();

        private Builder() {
        }

        public final Builder from(JdkColl instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllStr(instance.str());
            this.addAllInts(instance.ints());
            this.addAllOrds(instance.ords());
            this.addAllPols(instance.pols());
            this.addAllNavs(instance.navs());
            return this;
        }

        public final Builder addStr(String element) {
            this.strBuilder.add(Objects.requireNonNull(element, "str element"));
            return this;
        }

        public final Builder addStr(String ... elements) {
            for (String element : elements) {
                this.strBuilder.add(Objects.requireNonNull(element, "str element"));
            }
            return this;
        }

        public final Builder str(Iterable<String> elements) {
            this.strBuilder.clear();
            return this.addAllStr(elements);
        }

        public final Builder addAllStr(Iterable<String> elements) {
            for (String element : elements) {
                this.strBuilder.add(Objects.requireNonNull(element, "str element"));
            }
            return this;
        }

        public final Builder addInts(int element) {
            this.intsBuilder.add(element);
            return this;
        }

        public final Builder addInts(int ... elements) {
            for (int element : elements) {
                this.intsBuilder.add(element);
            }
            return this;
        }

        public final Builder ints(Iterable<Integer> elements) {
            this.intsBuilder.clear();
            return this.addAllInts(elements);
        }

        public final Builder addAllInts(Iterable<Integer> elements) {
            for (int element : elements) {
                this.intsBuilder.add(Objects.requireNonNull(Integer.valueOf(element), "ints element"));
            }
            return this;
        }

        public final Builder addOrds(int element) {
            this.ordsBuilder.add(element);
            return this;
        }

        public final Builder addOrds(int ... elements) {
            for (int element : elements) {
                this.ordsBuilder.add(element);
            }
            return this;
        }

        public final Builder ords(Iterable<Integer> elements) {
            this.ordsBuilder.clear();
            return this.addAllOrds(elements);
        }

        public final Builder addAllOrds(Iterable<Integer> elements) {
            for (int element : elements) {
                this.ordsBuilder.add(Objects.requireNonNull(Integer.valueOf(element), "ords element"));
            }
            return this;
        }

        public final Builder addPols(RetentionPolicy element) {
            this.polsBuilder.add(Objects.requireNonNull(element, "pols element"));
            return this;
        }

        public final Builder addPols(RetentionPolicy ... elements) {
            for (RetentionPolicy element : elements) {
                this.polsBuilder.add(Objects.requireNonNull(element, "pols element"));
            }
            return this;
        }

        public final Builder pols(Iterable<RetentionPolicy> elements) {
            this.polsBuilder.clear();
            return this.addAllPols(elements);
        }

        public final Builder addAllPols(Iterable<RetentionPolicy> elements) {
            for (RetentionPolicy element : elements) {
                this.polsBuilder.add(Objects.requireNonNull(element, "pols element"));
            }
            return this;
        }

        public final Builder addNavs(int element) {
            this.navsBuilder.add(element);
            return this;
        }

        public final Builder addNavs(int ... elements) {
            for (int element : elements) {
                this.navsBuilder.add(element);
            }
            return this;
        }

        public final Builder navs(Iterable<Integer> elements) {
            this.navsBuilder.clear();
            return this.addAllNavs(elements);
        }

        public final Builder addAllNavs(Iterable<Integer> elements) {
            for (int element : elements) {
                this.navsBuilder.add(Objects.requireNonNull(Integer.valueOf(element), "navs element"));
            }
            return this;
        }

        public ImmutableJdkColl build() throws IllegalStateException {
            return ImmutableJdkColl.validate(new ImmutableJdkColl(ImmutableJdkColl.createUnmodifiableList(true, this.strBuilder), ImmutableJdkColl.createUnmodifiableSet(this.intsBuilder), ImmutableJdkColl.createUnmodifiableSortedSet(false, ImmutableJdkColl.createSafeList(this.ordsBuilder)), ImmutableJdkColl.createUnmodifiableEnumSet(this.polsBuilder), ImmutableJdkColl.createUnmodifiableSortedSet(true, ImmutableJdkColl.createSafeList(this.navsBuilder))));
        }
    }
}

