/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jdkonly;

import io.atlassian.fugue.Option;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jdkonly.UsingAllOptionals;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableUsingAllOptionals
implements UsingAllOptionals {
    private final com.google.common.base.Optional<Integer> v1;
    @Nullable
    private final Integer v2;
    @Nullable
    private final Integer i1;
    @Nullable
    private final Long l1;
    @Nullable
    private final Double d1;
    private final com.atlassian.fugue.Option<String> fo2;
    private final Option<String> fo3;

    private ImmutableUsingAllOptionals(com.google.common.base.Optional<Integer> v1, Optional<Integer> v2, OptionalInt i1, OptionalLong l1, OptionalDouble d1, com.atlassian.fugue.Option<String> fo2, Option<String> fo3) {
        this.v1 = Objects.requireNonNull(v1, "v1");
        this.v2 = v2.orElse(null);
        this.i1 = i1.isPresent() ? Integer.valueOf(i1.getAsInt()) : null;
        this.l1 = l1.isPresent() ? Long.valueOf(l1.getAsLong()) : null;
        this.d1 = d1.isPresent() ? Double.valueOf(d1.getAsDouble()) : null;
        this.fo2 = Objects.requireNonNull(fo2, "fo2");
        this.fo3 = Objects.requireNonNull(fo3, "fo3");
    }

    private ImmutableUsingAllOptionals(ImmutableUsingAllOptionals original, com.google.common.base.Optional<Integer> v1, @Nullable Integer v2, @Nullable Integer i1, @Nullable Long l1, @Nullable Double d1, com.atlassian.fugue.Option<String> fo2, Option<String> fo3) {
        this.v1 = v1;
        this.v2 = v2;
        this.i1 = i1;
        this.l1 = l1;
        this.d1 = d1;
        this.fo2 = fo2;
        this.fo3 = fo3;
    }

    @Override
    public com.google.common.base.Optional<Integer> v1() {
        return this.v1;
    }

    @Override
    public Optional<Integer> v2() {
        return Optional.ofNullable(this.v2);
    }

    @Override
    public OptionalInt i1() {
        return this.i1 != null ? OptionalInt.of(this.i1) : OptionalInt.empty();
    }

    @Override
    public OptionalLong l1() {
        return this.l1 != null ? OptionalLong.of(this.l1) : OptionalLong.empty();
    }

    @Override
    public OptionalDouble d1() {
        return this.d1 != null ? OptionalDouble.of(this.d1) : OptionalDouble.empty();
    }

    @Override
    public com.atlassian.fugue.Option<String> fo2() {
        return this.fo2;
    }

    @Override
    public Option<String> fo3() {
        return this.fo3;
    }

    public final ImmutableUsingAllOptionals withV1(int value) {
        com.google.common.base.Optional newValue = com.google.common.base.Optional.of((Object)value);
        return new ImmutableUsingAllOptionals(this, (com.google.common.base.Optional<Integer>)newValue, this.v2, this.i1, this.l1, this.d1, this.fo2, this.fo3);
    }

    public final ImmutableUsingAllOptionals withV1(com.google.common.base.Optional<Integer> optional) {
        com.google.common.base.Optional<Integer> value = Objects.requireNonNull(optional, "v1");
        if (this.v1 == value) {
            return this;
        }
        return new ImmutableUsingAllOptionals(this, value, this.v2, this.i1, this.l1, this.d1, this.fo2, this.fo3);
    }

    public final ImmutableUsingAllOptionals withV2(int value) {
        Integer newValue = value;
        if (this.v2 == newValue) {
            return this;
        }
        return new ImmutableUsingAllOptionals(this, this.v1, newValue, this.i1, this.l1, this.d1, this.fo2, this.fo3);
    }

    public final ImmutableUsingAllOptionals withV2(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (this.v2 == value) {
            return this;
        }
        return new ImmutableUsingAllOptionals(this, this.v1, value, this.i1, this.l1, this.d1, this.fo2, this.fo3);
    }

    public final ImmutableUsingAllOptionals withI1(int value) {
        Integer newValue = value;
        if (this.i1 == newValue) {
            return this;
        }
        return new ImmutableUsingAllOptionals(this, this.v1, this.v2, newValue, this.l1, this.d1, this.fo2, this.fo3);
    }

    public final ImmutableUsingAllOptionals withI1(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (this.i1 == value) {
            return this;
        }
        return new ImmutableUsingAllOptionals(this, this.v1, this.v2, value, this.l1, this.d1, this.fo2, this.fo3);
    }

    public final ImmutableUsingAllOptionals withL1(long value) {
        Long newValue = value;
        if (this.l1 == newValue) {
            return this;
        }
        return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, newValue, this.d1, this.fo2, this.fo3);
    }

    public final ImmutableUsingAllOptionals withL1(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (this.l1 == value) {
            return this;
        }
        return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, value, this.d1, this.fo2, this.fo3);
    }

    public final ImmutableUsingAllOptionals withD1(double value) {
        Double newValue = value;
        return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, this.l1, newValue, this.fo2, this.fo3);
    }

    public final ImmutableUsingAllOptionals withD1(OptionalDouble optional) {
        Double value;
        Double d = value = optional.isPresent() ? Double.valueOf(optional.getAsDouble()) : null;
        if (Double.doubleToLongBits(this.d1) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, this.l1, value, this.fo2, this.fo3);
    }

    public final ImmutableUsingAllOptionals withFo2(String value) {
        com.atlassian.fugue.Option newValue = com.atlassian.fugue.Option.some((Object)value);
        return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, this.l1, this.d1, (com.atlassian.fugue.Option<String>)newValue, this.fo3);
    }

    public final ImmutableUsingAllOptionals withFo2(com.atlassian.fugue.Option<String> optional) {
        com.atlassian.fugue.Option<String> value = Objects.requireNonNull(optional, "fo2");
        if (this.fo2 == value) {
            return this;
        }
        return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, this.l1, this.d1, value, this.fo3);
    }

    public final ImmutableUsingAllOptionals withFo3(String value) {
        Option newValue = Option.some((Object)value);
        return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, this.l1, this.d1, this.fo2, (Option<String>)newValue);
    }

    public final ImmutableUsingAllOptionals withFo3(Option<String> optional) {
        Option<String> value = Objects.requireNonNull(optional, "fo3");
        if (this.fo3 == value) {
            return this;
        }
        return new ImmutableUsingAllOptionals(this, this.v1, this.v2, this.i1, this.l1, this.d1, this.fo2, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUsingAllOptionals && this.equalTo((ImmutableUsingAllOptionals)another);
    }

    private boolean equalTo(ImmutableUsingAllOptionals another) {
        return this.v1.equals(another.v1) && Objects.equals(this.v2, another.v2) && Objects.equals(this.i1, another.i1) && Objects.equals(this.l1, another.l1) && Objects.equals(this.d1, another.d1) && this.fo2.equals(another.fo2) && this.fo3.equals(another.fo3);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.v1.hashCode();
        h = h * 17 + Objects.hashCode(this.v2);
        h = h * 17 + Objects.hashCode(this.i1);
        h = h * 17 + Objects.hashCode(this.l1);
        h = h * 17 + Objects.hashCode(this.d1);
        h = h * 17 + this.fo2.hashCode();
        h = h * 17 + this.fo3.hashCode();
        return h;
    }

    public String toString() {
        return "UsingAllOptionals{v1=" + this.v1 + ", v2=" + this.v2() + ", i1=" + this.i1() + ", l1=" + this.l1() + ", d1=" + this.d1() + ", fo2=" + this.fo2 + ", fo3=" + this.fo3 + "}";
    }

    public static ImmutableUsingAllOptionals of(com.google.common.base.Optional<Integer> v1, Optional<Integer> v2, OptionalInt i1, OptionalLong l1, OptionalDouble d1, com.atlassian.fugue.Option<String> fo2, Option<String> fo3) {
        return new ImmutableUsingAllOptionals(v1, v2, i1, l1, d1, fo2, fo3);
    }

    public static ImmutableUsingAllOptionals copyOf(UsingAllOptionals instance) {
        if (instance instanceof ImmutableUsingAllOptionals) {
            return (ImmutableUsingAllOptionals)instance;
        }
        return ImmutableUsingAllOptionals.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private com.google.common.base.Optional<Integer> v1 = com.google.common.base.Optional.absent();
        @Nullable
        private Integer v2;
        @Nullable
        private Integer i1;
        @Nullable
        private Long l1;
        @Nullable
        private Double d1;
        private com.atlassian.fugue.Option<String> fo2 = com.atlassian.fugue.Option.none();
        private Option<String> fo3 = Option.none();

        private Builder() {
        }

        public final Builder from(UsingAllOptionals instance) {
            Option<String> fo3Optional;
            com.atlassian.fugue.Option<String> fo2Optional;
            OptionalDouble d1Optional;
            OptionalLong l1Optional;
            OptionalInt i1Optional;
            Optional<Integer> v2Optional;
            Objects.requireNonNull(instance, "instance");
            com.google.common.base.Optional<Integer> v1Optional = instance.v1();
            if (v1Optional.isPresent()) {
                this.v1(v1Optional);
            }
            if ((v2Optional = instance.v2()).isPresent()) {
                this.v2(v2Optional);
            }
            if ((i1Optional = instance.i1()).isPresent()) {
                this.i1(i1Optional);
            }
            if ((l1Optional = instance.l1()).isPresent()) {
                this.l1(l1Optional);
            }
            if ((d1Optional = instance.d1()).isPresent()) {
                this.d1(d1Optional);
            }
            if ((fo2Optional = instance.fo2()).isDefined()) {
                this.fo2(fo2Optional);
            }
            if ((fo3Optional = instance.fo3()).isDefined()) {
                this.fo3(fo3Optional);
            }
            return this;
        }

        public final Builder v1(int v1) {
            this.v1 = com.google.common.base.Optional.of((Object)v1);
            return this;
        }

        public final Builder v1(com.google.common.base.Optional<Integer> v1) {
            this.v1 = Objects.requireNonNull(v1, "v1");
            return this;
        }

        public final Builder v2(int v2) {
            this.v2 = Objects.requireNonNull(Integer.valueOf(v2), "v2");
            return this;
        }

        public final Builder v2(Optional<Integer> v2) {
            this.v2 = v2.orElse(null);
            return this;
        }

        public final Builder i1(int i1) {
            this.i1 = i1;
            return this;
        }

        public final Builder i1(OptionalInt i1) {
            this.i1 = i1.isPresent() ? Integer.valueOf(i1.getAsInt()) : null;
            return this;
        }

        public final Builder l1(long l1) {
            this.l1 = l1;
            return this;
        }

        public final Builder l1(OptionalLong l1) {
            this.l1 = l1.isPresent() ? Long.valueOf(l1.getAsLong()) : null;
            return this;
        }

        public final Builder d1(double d1) {
            this.d1 = d1;
            return this;
        }

        public final Builder d1(OptionalDouble d1) {
            this.d1 = d1.isPresent() ? Double.valueOf(d1.getAsDouble()) : null;
            return this;
        }

        public final Builder fo2(String fo2) {
            this.fo2 = com.atlassian.fugue.Option.some((Object)fo2);
            return this;
        }

        public final Builder fo2(com.atlassian.fugue.Option<String> fo2) {
            this.fo2 = Objects.requireNonNull(fo2, "fo2");
            return this;
        }

        public final Builder fo3(String fo3) {
            this.fo3 = Option.some((Object)fo3);
            return this;
        }

        public final Builder fo3(Option<String> fo3) {
            this.fo3 = Objects.requireNonNull(fo3, "fo3");
            return this;
        }

        public ImmutableUsingAllOptionals build() throws IllegalStateException {
            return new ImmutableUsingAllOptionals(null, this.v1, this.v2, this.i1, this.l1, this.d1, this.fo2, this.fo3);
        }
    }
}

