/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jdkonly;

import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jdkonly.JdkMaps;

@ParametersAreNonnullByDefault
@NotThreadSafe
public final class JdkMapsBuilder {
    private Map<Long, Integer> justBuilder = new LinkedHashMap<Long, Integer>();
    private Map<Integer, String> ordsBuilder = new LinkedHashMap<Integer, String>();
    private EnumMap<RetentionPolicy, Integer> polsBuilder = new EnumMap(RetentionPolicy.class);
    private Map<String, Integer> navsBuilder = new LinkedHashMap<String, Integer>();

    public final JdkMapsBuilder from(JdkMaps instance) {
        Objects.requireNonNull(instance, "instance");
        this.putAllJust(instance.just());
        this.putAllOrds(instance.ords());
        this.putAllPols(instance.pols());
        this.putAllNavs(instance.navs());
        return this;
    }

    public final JdkMapsBuilder putJust(long key, int value) {
        this.justBuilder.put(Objects.requireNonNull(Long.valueOf(key), "just key"), Objects.requireNonNull(Integer.valueOf(value), "just value"));
        return this;
    }

    public final JdkMapsBuilder putJust(Map.Entry<Long, ? extends Integer> entry) {
        this.justBuilder.put(Objects.requireNonNull(entry.getKey(), "just key"), Objects.requireNonNull(entry.getValue(), "just value"));
        return this;
    }

    public final JdkMapsBuilder just(Map<Long, ? extends Integer> entries) {
        this.justBuilder.clear();
        return this.putAllJust(entries);
    }

    public final JdkMapsBuilder putAllJust(Map<Long, ? extends Integer> entries) {
        for (Map.Entry<Long, ? extends Integer> entry : entries.entrySet()) {
            this.justBuilder.put(Objects.requireNonNull(entry.getKey(), "just key"), Objects.requireNonNull(entry.getValue(), "just value"));
        }
        return this;
    }

    public final JdkMapsBuilder putOrds(int key, String value) {
        this.ordsBuilder.put(Objects.requireNonNull(Integer.valueOf(key), "ords key"), Objects.requireNonNull(value, "ords value"));
        return this;
    }

    public final JdkMapsBuilder putOrds(Map.Entry<Integer, ? extends String> entry) {
        this.ordsBuilder.put(Objects.requireNonNull(entry.getKey(), "ords key"), Objects.requireNonNull(entry.getValue(), "ords value"));
        return this;
    }

    public final JdkMapsBuilder ords(Map<Integer, ? extends String> entries) {
        this.ordsBuilder.clear();
        return this.putAllOrds(entries);
    }

    public final JdkMapsBuilder putAllOrds(Map<Integer, ? extends String> entries) {
        for (Map.Entry<Integer, ? extends String> entry : entries.entrySet()) {
            this.ordsBuilder.put(Objects.requireNonNull(entry.getKey(), "ords key"), Objects.requireNonNull(entry.getValue(), "ords value"));
        }
        return this;
    }

    public final JdkMapsBuilder putPols(RetentionPolicy key, int value) {
        this.polsBuilder.put((RetentionPolicy)((Enum)Objects.requireNonNull(key, "pols key")), Objects.requireNonNull(Integer.valueOf(value), "pols value"));
        return this;
    }

    public final JdkMapsBuilder putPols(Map.Entry<RetentionPolicy, ? extends Integer> entry) {
        this.polsBuilder.put((RetentionPolicy)((Enum)Objects.requireNonNull(entry.getKey(), "pols key")), Objects.requireNonNull(entry.getValue(), "pols value"));
        return this;
    }

    public final JdkMapsBuilder pols(Map<RetentionPolicy, ? extends Integer> entries) {
        this.polsBuilder.clear();
        return this.putAllPols(entries);
    }

    public final JdkMapsBuilder putAllPols(Map<RetentionPolicy, ? extends Integer> entries) {
        for (Map.Entry<RetentionPolicy, ? extends Integer> entry : entries.entrySet()) {
            this.polsBuilder.put((RetentionPolicy)((Enum)Objects.requireNonNull(entry.getKey(), "pols key")), Objects.requireNonNull(entry.getValue(), "pols value"));
        }
        return this;
    }

    public final JdkMapsBuilder putNavs(String key, int value) {
        this.navsBuilder.put(Objects.requireNonNull(key, "navs key"), Objects.requireNonNull(Integer.valueOf(value), "navs value"));
        return this;
    }

    public final JdkMapsBuilder putNavs(Map.Entry<String, ? extends Integer> entry) {
        this.navsBuilder.put(Objects.requireNonNull(entry.getKey(), "navs key"), Objects.requireNonNull(entry.getValue(), "navs value"));
        return this;
    }

    public final JdkMapsBuilder navs(Map<String, ? extends Integer> entries) {
        this.navsBuilder.clear();
        return this.putAllNavs(entries);
    }

    public final JdkMapsBuilder putAllNavs(Map<String, ? extends Integer> entries) {
        for (Map.Entry<String, ? extends Integer> entry : entries.entrySet()) {
            this.navsBuilder.put(Objects.requireNonNull(entry.getKey(), "navs key"), Objects.requireNonNull(entry.getValue(), "navs value"));
        }
        return this;
    }

    public JdkMaps build() throws IllegalStateException {
        return ImmutableJdkMaps.validate(new ImmutableJdkMaps(this));
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, Map<? extends K, ? extends V> map) {
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        linkedMap.putAll(map);
        if (checkNulls) {
            for (Map.Entry e : linkedMap.entrySet()) {
                Objects.requireNonNull(e.getKey(), "key");
                Objects.requireNonNull(e.getValue(), "value");
            }
        }
        switch (linkedMap.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry e = linkedMap.entrySet().iterator().next();
                return Collections.singletonMap(e.getKey(), e.getValue());
            }
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    private static <K extends Enum<K>, V> Map<K, V> createUnmodifiableEnumMap(boolean checkNulls, Map<K, ? extends V> map) {
        EnumMap<K, ? extends V> enumMap = new EnumMap<K, V>(map);
        if (checkNulls) {
            for (V value : map.values()) {
                Objects.requireNonNull(value, "value");
            }
        }
        return Collections.unmodifiableMap(enumMap);
    }

    private static <K extends Comparable<K>, V> NavigableMap<K, V> createUnmodifiableSortedMap(boolean reverse, boolean checkNulls, Map<? extends K, ? extends V> map) {
        TreeMap sortedMap = reverse ? new TreeMap(Collections.reverseOrder()) : new TreeMap();
        sortedMap.putAll(map);
        if (checkNulls) {
            for (Map.Entry e : sortedMap.entrySet()) {
                Objects.requireNonNull(e.getKey(), "key");
                Objects.requireNonNull(e.getValue(), "value");
            }
        }
        return Collections.unmodifiableNavigableMap(sortedMap);
    }

    @Immutable
    private static final class ImmutableJdkMaps
    implements JdkMaps {
        private final Map<Long, Integer> just;
        private final SortedMap<Integer, String> ords;
        private final Map<RetentionPolicy, Integer> pols;
        private final NavigableMap<String, Integer> navs;
        private static final ImmutableJdkMaps INSTANCE = ImmutableJdkMaps.validate(new ImmutableJdkMaps());

        private ImmutableJdkMaps() {
            this.just = Collections.emptyMap();
            this.ords = JdkMapsBuilder.createUnmodifiableSortedMap(false, false, Collections.emptyMap());
            this.pols = Collections.emptyMap();
            this.navs = JdkMapsBuilder.createUnmodifiableSortedMap(true, false, Collections.emptyMap());
        }

        private ImmutableJdkMaps(JdkMapsBuilder builder) {
            this.just = JdkMapsBuilder.createUnmodifiableMap(false, builder.justBuilder);
            this.ords = JdkMapsBuilder.createUnmodifiableSortedMap(false, false, builder.ordsBuilder);
            this.pols = JdkMapsBuilder.createUnmodifiableEnumMap(false, builder.polsBuilder);
            this.navs = JdkMapsBuilder.createUnmodifiableSortedMap(true, false, builder.navsBuilder);
        }

        @Override
        public Map<Long, Integer> just() {
            return this.just;
        }

        @Override
        public SortedMap<Integer, String> ords() {
            return this.ords;
        }

        @Override
        public Map<RetentionPolicy, Integer> pols() {
            return this.pols;
        }

        @Override
        public NavigableMap<String, Integer> navs() {
            return this.navs;
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableJdkMaps && this.equalTo((ImmutableJdkMaps)another);
        }

        private boolean equalTo(ImmutableJdkMaps another) {
            return this.just.equals(another.just) && this.ords.equals(another.ords) && this.pols.equals(another.pols) && this.navs.equals(another.navs);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.just.hashCode();
            h = h * 17 + this.ords.hashCode();
            h = h * 17 + this.pols.hashCode();
            h = h * 17 + this.navs.hashCode();
            return h;
        }

        public String toString() {
            return "JdkMaps{just=" + this.just + ", ords=" + this.ords + ", pols=" + this.pols + ", navs=" + this.navs + "}";
        }

        public static JdkMaps of() {
            return INSTANCE;
        }

        private static ImmutableJdkMaps validate(ImmutableJdkMaps instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }
    }
}

