/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.ClearBuilder;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableClearBuilder
implements ClearBuilder {
    private final boolean a;
    private final String b;
    private final List<String> l;
    private final int d;
    private final Set<RetentionPolicy> r;
    private final Map<String, Integer> m;

    private ImmutableClearBuilder(Builder builder) {
        this.a = builder.a;
        this.b = builder.b;
        this.l = ImmutableClearBuilder.createUnmodifiableList(true, builder.lBuilder);
        this.r = ImmutableClearBuilder.createUnmodifiableEnumSet(builder.rBuilder);
        this.m = ImmutableClearBuilder.createUnmodifiableMap(false, builder.mBuilder);
        this.d = builder.dIsSet() ? builder.d : ClearBuilder.super.d();
    }

    private ImmutableClearBuilder(boolean a, String b, List<String> l, int d, Set<RetentionPolicy> r, Map<String, Integer> m) {
        this.a = a;
        this.b = b;
        this.l = l;
        this.d = d;
        this.r = r;
        this.m = m;
    }

    @Override
    public boolean a() {
        return this.a;
    }

    @Override
    public String b() {
        return this.b;
    }

    @Override
    public List<String> l() {
        return this.l;
    }

    @Override
    public int d() {
        return this.d;
    }

    @Override
    public Set<RetentionPolicy> r() {
        return this.r;
    }

    @Override
    public Map<String, Integer> m() {
        return this.m;
    }

    public final ImmutableClearBuilder withA(boolean value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableClearBuilder(value, this.b, this.l, this.d, this.r, this.m);
    }

    public final ImmutableClearBuilder withB(String value) {
        if (this.b.equals(value)) {
            return this;
        }
        return new ImmutableClearBuilder(this.a, Objects.requireNonNull(value, "b"), this.l, this.d, this.r, this.m);
    }

    public final ImmutableClearBuilder withL(String ... elements) {
        List<String> newValue = ImmutableClearBuilder.createUnmodifiableList(false, ImmutableClearBuilder.createSafeList(Arrays.asList(elements)));
        return new ImmutableClearBuilder(this.a, this.b, newValue, this.d, this.r, this.m);
    }

    public final ImmutableClearBuilder withL(Iterable<String> elements) {
        if (this.l == elements) {
            return this;
        }
        List<String> newValue = ImmutableClearBuilder.createUnmodifiableList(false, ImmutableClearBuilder.createSafeList(elements));
        return new ImmutableClearBuilder(this.a, this.b, newValue, this.d, this.r, this.m);
    }

    public final ImmutableClearBuilder withD(int value) {
        if (this.d == value) {
            return this;
        }
        return new ImmutableClearBuilder(this.a, this.b, this.l, value, this.r, this.m);
    }

    public final ImmutableClearBuilder withR(RetentionPolicy ... elements) {
        Set<RetentionPolicy> newValue = ImmutableClearBuilder.createUnmodifiableEnumSet(Arrays.asList(elements));
        return new ImmutableClearBuilder(this.a, this.b, this.l, this.d, newValue, this.m);
    }

    public final ImmutableClearBuilder withR(Iterable<RetentionPolicy> elements) {
        if (this.r == elements) {
            return this;
        }
        Set<RetentionPolicy> newValue = ImmutableClearBuilder.createUnmodifiableEnumSet(elements);
        return new ImmutableClearBuilder(this.a, this.b, this.l, this.d, newValue, this.m);
    }

    public final ImmutableClearBuilder withM(Map<String, ? extends Integer> entries) {
        if (this.m == entries) {
            return this;
        }
        Map<String, Integer> value = ImmutableClearBuilder.createUnmodifiableMap(true, entries);
        return new ImmutableClearBuilder(this.a, this.b, this.l, this.d, this.r, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClearBuilder && this.equalTo((ImmutableClearBuilder)another);
    }

    private boolean equalTo(ImmutableClearBuilder another) {
        return this.a == another.a && this.b.equals(another.b) && this.l.equals(another.l) && this.d == another.d && this.r.equals(another.r) && this.m.equals(another.m);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Boolean.hashCode(this.a);
        h = h * 17 + this.b.hashCode();
        h = h * 17 + this.l.hashCode();
        h = h * 17 + this.d;
        h = h * 17 + this.r.hashCode();
        h = h * 17 + this.m.hashCode();
        return h;
    }

    public String toString() {
        return "ClearBuilder{a=" + this.a + ", b=" + this.b + ", l=" + this.l + ", d=" + this.d + ", r=" + this.r + ", m=" + this.m + "}";
    }

    public static ImmutableClearBuilder copyOf(ClearBuilder instance) {
        if (instance instanceof ImmutableClearBuilder) {
            return (ImmutableClearBuilder)instance;
        }
        return ImmutableClearBuilder.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> ArrayList<T> createSafeList(Iterable<? extends T> iterable) {
        ArrayList<T> list = iterable instanceof Collection ? new ArrayList<T>(((Collection)iterable).size()) : new ArrayList();
        for (T element : iterable) {
            list.add(Objects.requireNonNull(element, "element"));
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        ArrayList<T> list = ImmutableClearBuilder.createSafeList(iterable);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, Map<? extends K, ? extends V> map) {
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        linkedMap.putAll(map);
        if (checkNulls) {
            for (Map.Entry e : linkedMap.entrySet()) {
                Objects.requireNonNull(e.getKey(), "key");
                Objects.requireNonNull(e.getValue(), "value");
            }
        }
        switch (linkedMap.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry e = linkedMap.entrySet().iterator().next();
                return Collections.singletonMap(e.getKey(), e.getValue());
            }
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private static final long INIT_BIT_B = 2L;
        private static final long OPT_BIT_D = 1L;
        private long initBits = 3L;
        private long optBits;
        private boolean a;
        @Nullable
        private String b;
        private ArrayList<String> lBuilder = new ArrayList();
        private int d;
        private EnumSet<RetentionPolicy> rBuilder = EnumSet.noneOf(RetentionPolicy.class);
        private Map<String, Integer> mBuilder = new LinkedHashMap<String, Integer>();

        private Builder() {
        }

        public final Builder from(ClearBuilder instance) {
            Objects.requireNonNull(instance, "instance");
            this.a(instance.a());
            this.b(instance.b());
            this.addAllL(instance.l());
            this.d(instance.d());
            this.addAllR(instance.r());
            this.putAllM(instance.m());
            return this;
        }

        public final Builder a(boolean a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder b(String b) {
            this.b = Objects.requireNonNull(b, "b");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addL(String element) {
            this.lBuilder.add(Objects.requireNonNull(element, "l element"));
            return this;
        }

        public final Builder addL(String ... elements) {
            for (String element : elements) {
                this.lBuilder.add(Objects.requireNonNull(element, "l element"));
            }
            return this;
        }

        public final Builder l(Iterable<String> elements) {
            this.lBuilder.clear();
            return this.addAllL(elements);
        }

        public final Builder addAllL(Iterable<String> elements) {
            for (String element : elements) {
                this.lBuilder.add(Objects.requireNonNull(element, "l element"));
            }
            return this;
        }

        public final Builder d(int d) {
            this.d = d;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addR(RetentionPolicy element) {
            this.rBuilder.add(Objects.requireNonNull(element, "r element"));
            return this;
        }

        public final Builder addR(RetentionPolicy ... elements) {
            for (RetentionPolicy element : elements) {
                this.rBuilder.add(Objects.requireNonNull(element, "r element"));
            }
            return this;
        }

        public final Builder r(Iterable<RetentionPolicy> elements) {
            this.rBuilder.clear();
            return this.addAllR(elements);
        }

        public final Builder addAllR(Iterable<RetentionPolicy> elements) {
            for (RetentionPolicy element : elements) {
                this.rBuilder.add(Objects.requireNonNull(element, "r element"));
            }
            return this;
        }

        public final Builder putM(String key, int value) {
            this.mBuilder.put(Objects.requireNonNull(key, "m key"), Objects.requireNonNull(Integer.valueOf(value), "m value"));
            return this;
        }

        public final Builder putM(Map.Entry<String, ? extends Integer> entry) {
            this.mBuilder.put(Objects.requireNonNull(entry.getKey(), "m key"), Objects.requireNonNull(entry.getValue(), "m value"));
            return this;
        }

        public final Builder m(Map<String, ? extends Integer> entries) {
            this.mBuilder.clear();
            return this.putAllM(entries);
        }

        public final Builder putAllM(Map<String, ? extends Integer> entries) {
            for (Map.Entry<String, ? extends Integer> entry : entries.entrySet()) {
                this.mBuilder.put(Objects.requireNonNull(entry.getKey(), "m key"), Objects.requireNonNull(entry.getValue(), "m value"));
            }
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.optBits = 0L;
            this.a = false;
            this.b = null;
            this.lBuilder.clear();
            this.d = 0;
            this.rBuilder.clear();
            this.mBuilder.clear();
            return this;
        }

        public ImmutableClearBuilder build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableClearBuilder(this);
        }

        private boolean dIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("b");
            }
            return "Cannot build ClearBuilder, some of required attributes are not set " + attributes;
        }
    }
}

