/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.Companion;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableCompanion
implements Companion {
    private final int integer;
    private final String string;
    @Nullable
    private final Boolean bools;
    private final ImmutableList<String> str;
    private final ImmutableSet<Integer> ints;
    private final int[] arrayInts;
    private final String[] arrayStrings;
    private final ImmutableSortedSet<Integer> ords;
    private final ImmutableSet<RetentionPolicy> pols;
    private final ImmutableSortedSet<Integer> navs;
    private final ImmutableMap<Long, Integer> just;
    private final ImmutableSortedMap<Integer, String> ordsmap;
    private final ImmutableMap<RetentionPolicy, Integer> polsmap;
    private final ImmutableSortedMap<String, Integer> navsmap;

    private ImmutableCompanion(int integer, String string, @Nullable Boolean bools, ImmutableList<String> str, ImmutableSet<Integer> ints, int[] arrayInts, String[] arrayStrings, ImmutableSortedSet<Integer> ords, ImmutableSet<RetentionPolicy> pols, ImmutableSortedSet<Integer> navs, ImmutableMap<Long, Integer> just, ImmutableSortedMap<Integer, String> ordsmap, ImmutableMap<RetentionPolicy, Integer> polsmap, ImmutableSortedMap<String, Integer> navsmap) {
        this.integer = integer;
        this.string = string;
        this.bools = bools;
        this.str = str;
        this.ints = ints;
        this.arrayInts = arrayInts;
        this.arrayStrings = arrayStrings;
        this.ords = ords;
        this.pols = pols;
        this.navs = navs;
        this.just = just;
        this.ordsmap = ordsmap;
        this.polsmap = polsmap;
        this.navsmap = navsmap;
    }

    @Override
    public int integer() {
        return this.integer;
    }

    @Override
    public String string() {
        return this.string;
    }

    @Override
    @Nullable
    public Boolean bools() {
        return this.bools;
    }

    public ImmutableList<String> str() {
        return this.str;
    }

    public ImmutableSet<Integer> ints() {
        return this.ints;
    }

    @Override
    public int[] arrayInts() {
        return (int[])this.arrayInts.clone();
    }

    @Override
    public String[] arrayStrings() {
        return (String[])this.arrayStrings.clone();
    }

    public ImmutableSortedSet<Integer> ords() {
        return this.ords;
    }

    public ImmutableSet<RetentionPolicy> pols() {
        return this.pols;
    }

    public ImmutableSortedSet<Integer> navs() {
        return this.navs;
    }

    public ImmutableMap<Long, Integer> just() {
        return this.just;
    }

    public ImmutableSortedMap<Integer, String> ordsmap() {
        return this.ordsmap;
    }

    public ImmutableMap<RetentionPolicy, Integer> polsmap() {
        return this.polsmap;
    }

    public ImmutableSortedMap<String, Integer> navsmap() {
        return this.navsmap;
    }

    public final ImmutableCompanion withInteger(int value) {
        if (this.integer == value) {
            return this;
        }
        return new ImmutableCompanion(value, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withString(String value) {
        if (this.string.equals(value)) {
            return this;
        }
        return new ImmutableCompanion(this.integer, (String)Preconditions.checkNotNull((Object)value, (Object)"string"), this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withBools(@Nullable Boolean value) {
        if (Objects.equal((Object)this.bools, (Object)value)) {
            return this;
        }
        return new ImmutableCompanion(this.integer, this.string, value, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withStr(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCompanion(this.integer, this.string, this.bools, (ImmutableList<String>)newValue, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withStr(Iterable<String> elements) {
        if (this.str == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCompanion(this.integer, this.string, this.bools, (ImmutableList<String>)newValue, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withInts(int ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, (ImmutableSet<Integer>)newValue, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withInts(Iterable<Integer> elements) {
        if (this.ints == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, (ImmutableSet<Integer>)newValue, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withArrayInts(int ... elements) {
        int[] newValue = (int[])elements.clone();
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, newValue, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withArrayStrings(String ... elements) {
        String[] newValue = (String[])elements.clone();
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, newValue, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withOrds(int ... elements) {
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), (Collection)Ints.asList((int[])elements));
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, (ImmutableSortedSet<Integer>)newValue, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withOrds(Iterable<Integer> elements) {
        if (this.ords == elements) {
            return this;
        }
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), elements);
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, (ImmutableSortedSet<Integer>)newValue, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withPols(RetentionPolicy ... elements) {
        ImmutableSet newValue = Sets.immutableEnumSet(Arrays.asList(elements));
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, (ImmutableSet<RetentionPolicy>)newValue, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withPols(Iterable<RetentionPolicy> elements) {
        if (this.pols == elements) {
            return this;
        }
        ImmutableSet newValue = Sets.immutableEnumSet(elements);
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, (ImmutableSet<RetentionPolicy>)newValue, this.navs, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withNavs(int ... elements) {
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural().reverse(), (Collection)Ints.asList((int[])elements));
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, (ImmutableSortedSet<Integer>)newValue, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withNavs(Iterable<Integer> elements) {
        if (this.navs == elements) {
            return this;
        }
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural().reverse(), elements);
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, (ImmutableSortedSet<Integer>)newValue, this.just, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withJust(Map<Long, ? extends Integer> entries) {
        if (this.just == entries) {
            return this;
        }
        ImmutableMap value = ImmutableMap.copyOf(entries);
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, (ImmutableMap<Long, Integer>)value, this.ordsmap, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withOrdsmap(Map<Integer, ? extends String> entries) {
        if (this.ordsmap == entries) {
            return this;
        }
        ImmutableSortedMap value = ImmutableSortedMap.copyOf(entries, (Comparator)Ordering.natural());
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, (ImmutableSortedMap<Integer, String>)value, this.polsmap, this.navsmap);
    }

    public final ImmutableCompanion withPolsmap(Map<RetentionPolicy, ? extends Integer> entries) {
        if (this.polsmap == entries) {
            return this;
        }
        ImmutableMap value = Maps.immutableEnumMap(entries);
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, (ImmutableMap<RetentionPolicy, Integer>)value, this.navsmap);
    }

    public final ImmutableCompanion withNavsmap(Map<String, ? extends Integer> entries) {
        if (this.navsmap == entries) {
            return this;
        }
        ImmutableSortedMap value = ImmutableSortedMap.copyOf(entries, (Comparator)Ordering.natural().reverse());
        return new ImmutableCompanion(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs, this.just, this.ordsmap, this.polsmap, (ImmutableSortedMap<String, Integer>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCompanion && this.equalTo((ImmutableCompanion)another);
    }

    private boolean equalTo(ImmutableCompanion another) {
        return this.integer == another.integer && this.string.equals(another.string) && Objects.equal((Object)this.bools, (Object)another.bools) && this.str.equals(another.str) && this.ints.equals(another.ints) && Arrays.equals(this.arrayInts, another.arrayInts) && Arrays.equals(this.arrayStrings, another.arrayStrings) && this.ords.equals(another.ords) && this.pols.equals(another.pols) && this.navs.equals(another.navs) && this.just.equals(another.just) && this.ordsmap.equals(another.ordsmap) && this.polsmap.equals(another.polsmap) && this.navsmap.equals(another.navsmap);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.integer;
        h = h * 17 + this.string.hashCode();
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.bools});
        h = h * 17 + this.str.hashCode();
        h = h * 17 + this.ints.hashCode();
        h = h * 17 + Arrays.hashCode(this.arrayInts);
        h = h * 17 + Arrays.hashCode(this.arrayStrings);
        h = h * 17 + this.ords.hashCode();
        h = h * 17 + this.pols.hashCode();
        h = h * 17 + this.navs.hashCode();
        h = h * 17 + this.just.hashCode();
        h = h * 17 + this.ordsmap.hashCode();
        h = h * 17 + this.polsmap.hashCode();
        h = h * 17 + this.navsmap.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Companion").add("integer", this.integer).add("string", (Object)this.string).add("bools", (Object)this.bools).add("str", this.str).add("ints", this.ints).add("arrayInts", (Object)Arrays.toString(this.arrayInts)).add("arrayStrings", (Object)Arrays.toString(this.arrayStrings)).add("ords", this.ords).add("pols", this.pols).add("navs", this.navs).add("just", this.just).add("ordsmap", this.ordsmap).add("polsmap", this.polsmap).add("navsmap", this.navsmap).toString();
    }

    public static ImmutableCompanion copyOf(Companion instance) {
        if (instance instanceof ImmutableCompanion) {
            return (ImmutableCompanion)instance;
        }
        return ImmutableCompanion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_INTEGER = 1L;
        private static final long INIT_BIT_STRING = 2L;
        private static final long INIT_BIT_ARRAY_INTS = 4L;
        private static final long INIT_BIT_ARRAY_STRINGS = 8L;
        private long initBits = 15L;
        private int integer;
        @Nullable
        private String string;
        @Nullable
        private Boolean bools;
        private ImmutableList.Builder<String> strBuilder = ImmutableList.builder();
        private ImmutableSet.Builder<Integer> intsBuilder = ImmutableSet.builder();
        @Nullable
        private int[] arrayInts;
        @Nullable
        private String[] arrayStrings;
        private ImmutableSortedSet.Builder<Integer> ordsBuilder = ImmutableSortedSet.naturalOrder();
        private ImmutableSet.Builder<RetentionPolicy> polsBuilder = ImmutableSet.builder();
        private ImmutableSortedSet.Builder<Integer> navsBuilder = ImmutableSortedSet.reverseOrder();
        private ImmutableMap.Builder<Long, Integer> justBuilder = ImmutableMap.builder();
        private ImmutableSortedMap.Builder<Integer, String> ordsmapBuilder = ImmutableSortedMap.naturalOrder();
        private ImmutableMap.Builder<RetentionPolicy, Integer> polsmapBuilder = ImmutableMap.builder();
        private ImmutableSortedMap.Builder<String, Integer> navsmapBuilder = ImmutableSortedMap.reverseOrder();

        private Builder() {
        }

        public final Builder from(Companion instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.integer(instance.integer());
            this.string(instance.string());
            Boolean boolsValue = instance.bools();
            if (boolsValue != null) {
                this.bools(boolsValue);
            }
            this.addAllStr(instance.str());
            this.addAllInts(instance.ints());
            this.arrayInts(instance.arrayInts());
            this.arrayStrings(instance.arrayStrings());
            this.addAllOrds(instance.ords());
            this.addAllPols(instance.pols());
            this.addAllNavs(instance.navs());
            this.putAllJust(instance.just());
            this.putAllOrdsmap(instance.ordsmap());
            this.putAllPolsmap(instance.polsmap());
            this.putAllNavsmap(instance.navsmap());
            return this;
        }

        public final Builder integer(int integer) {
            this.integer = integer;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder string(String string) {
            this.string = (String)Preconditions.checkNotNull((Object)string, (Object)"string");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder bools(@Nullable Boolean bools) {
            this.bools = bools;
            return this;
        }

        public final Builder addStr(String element) {
            this.strBuilder.add((Object)element);
            return this;
        }

        public final Builder addStr(String ... elements) {
            this.strBuilder.add((Object[])elements);
            return this;
        }

        public final Builder str(Iterable<String> elements) {
            this.strBuilder = ImmutableList.builder();
            return this.addAllStr(elements);
        }

        public final Builder addAllStr(Iterable<String> elements) {
            this.strBuilder.addAll(elements);
            return this;
        }

        public final Builder addInts(int element) {
            this.intsBuilder.add((Object)element);
            return this;
        }

        public final Builder addInts(int ... elements) {
            this.intsBuilder.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        public final Builder ints(Iterable<Integer> elements) {
            this.intsBuilder = ImmutableSet.builder();
            return this.addAllInts(elements);
        }

        public final Builder addAllInts(Iterable<Integer> elements) {
            this.intsBuilder.addAll(elements);
            return this;
        }

        public final Builder arrayInts(int ... elements) {
            this.arrayInts = (int[])elements.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder arrayStrings(String ... elements) {
            this.arrayStrings = (String[])elements.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder addOrds(int element) {
            this.ordsBuilder.add((Object)element);
            return this;
        }

        public final Builder addOrds(int ... elements) {
            this.ordsBuilder.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        public final Builder ords(Iterable<Integer> elements) {
            this.ordsBuilder = ImmutableSortedSet.naturalOrder();
            return this.addAllOrds(elements);
        }

        public final Builder addAllOrds(Iterable<Integer> elements) {
            this.ordsBuilder.addAll(elements);
            return this;
        }

        public final Builder addPols(RetentionPolicy element) {
            this.polsBuilder.add((Object)element);
            return this;
        }

        public final Builder addPols(RetentionPolicy ... elements) {
            this.polsBuilder.addAll(Arrays.asList(elements));
            return this;
        }

        public final Builder pols(Iterable<RetentionPolicy> elements) {
            this.polsBuilder = ImmutableSet.builder();
            return this.addAllPols(elements);
        }

        public final Builder addAllPols(Iterable<RetentionPolicy> elements) {
            this.polsBuilder.addAll(elements);
            return this;
        }

        public final Builder addNavs(int element) {
            this.navsBuilder.add((Object)element);
            return this;
        }

        public final Builder addNavs(int ... elements) {
            this.navsBuilder.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        public final Builder navs(Iterable<Integer> elements) {
            this.navsBuilder = ImmutableSortedSet.reverseOrder();
            return this.addAllNavs(elements);
        }

        public final Builder addAllNavs(Iterable<Integer> elements) {
            this.navsBuilder.addAll(elements);
            return this;
        }

        public final Builder putJust(long key, int value) {
            this.justBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putJust(Map.Entry<Long, ? extends Integer> entry) {
            this.justBuilder.put(entry);
            return this;
        }

        public final Builder just(Map<Long, ? extends Integer> entries) {
            this.justBuilder = ImmutableMap.builder();
            return this.putAllJust(entries);
        }

        public final Builder putAllJust(Map<Long, ? extends Integer> entries) {
            this.justBuilder.putAll(entries);
            return this;
        }

        public final Builder putOrdsmap(int key, String value) {
            this.ordsmapBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putOrdsmap(Map.Entry<Integer, ? extends String> entry) {
            this.ordsmapBuilder.put(entry);
            return this;
        }

        public final Builder ordsmap(Map<Integer, ? extends String> entries) {
            this.ordsmapBuilder = ImmutableSortedMap.naturalOrder();
            return this.putAllOrdsmap(entries);
        }

        public final Builder putAllOrdsmap(Map<Integer, ? extends String> entries) {
            this.ordsmapBuilder.putAll(entries);
            return this;
        }

        public final Builder putPolsmap(RetentionPolicy key, int value) {
            this.polsmapBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putPolsmap(Map.Entry<RetentionPolicy, ? extends Integer> entry) {
            this.polsmapBuilder.put(entry);
            return this;
        }

        public final Builder polsmap(Map<RetentionPolicy, ? extends Integer> entries) {
            this.polsmapBuilder = ImmutableMap.builder();
            return this.putAllPolsmap(entries);
        }

        public final Builder putAllPolsmap(Map<RetentionPolicy, ? extends Integer> entries) {
            this.polsmapBuilder.putAll(entries);
            return this;
        }

        public final Builder putNavsmap(String key, int value) {
            this.navsmapBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putNavsmap(Map.Entry<String, ? extends Integer> entry) {
            this.navsmapBuilder.put(entry);
            return this;
        }

        public final Builder navsmap(Map<String, ? extends Integer> entries) {
            this.navsmapBuilder = ImmutableSortedMap.reverseOrder();
            return this.putAllNavsmap(entries);
        }

        public final Builder putAllNavsmap(Map<String, ? extends Integer> entries) {
            this.navsmapBuilder.putAll(entries);
            return this;
        }

        public ImmutableCompanion build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCompanion(this.integer, this.string, this.bools, this.strBuilder.build(), this.intsBuilder.build(), this.arrayInts, this.arrayStrings, this.ordsBuilder.build(), Sets.immutableEnumSet((Iterable)this.polsBuilder.build()), this.navsBuilder.build(), this.justBuilder.build(), this.ordsmapBuilder.build(), Maps.immutableEnumMap((Map)this.polsmapBuilder.build()), this.navsmapBuilder.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("integer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("string");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("arrayInts");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("arrayStrings");
            }
            return "Cannot build Companion, some of required attributes are not set " + attributes;
        }
    }
}

