/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.Companion;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableJdkComp
implements Companion.JdkComp {
    private final int integer;
    private final String string;
    @Nullable
    private final Boolean bools;
    private final List<String> str;
    private final Set<Integer> ints;
    private final int[] arrayInts;
    private final String[] arrayStrings;
    private final SortedSet<Integer> ords;
    private final Set<RetentionPolicy> pols;
    private final NavigableSet<Integer> navs;

    private ImmutableJdkComp(int integer, String string, @Nullable Boolean bools, List<String> str, Set<Integer> ints, int[] arrayInts, String[] arrayStrings, SortedSet<Integer> ords, Set<RetentionPolicy> pols, NavigableSet<Integer> navs) {
        this.integer = integer;
        this.string = string;
        this.bools = bools;
        this.str = str;
        this.ints = ints;
        this.arrayInts = arrayInts;
        this.arrayStrings = arrayStrings;
        this.ords = ords;
        this.pols = pols;
        this.navs = navs;
    }

    @Override
    public int integer() {
        return this.integer;
    }

    @Override
    public String string() {
        return this.string;
    }

    @Override
    @Nullable
    public Boolean bools() {
        return this.bools;
    }

    @Override
    public List<String> str() {
        return this.str;
    }

    @Override
    public Set<Integer> ints() {
        return this.ints;
    }

    @Override
    public int[] arrayInts() {
        return (int[])this.arrayInts.clone();
    }

    @Override
    public String[] arrayStrings() {
        return (String[])this.arrayStrings.clone();
    }

    @Override
    public SortedSet<Integer> ords() {
        return this.ords;
    }

    @Override
    public Set<RetentionPolicy> pols() {
        return this.pols;
    }

    @Override
    public NavigableSet<Integer> navs() {
        return this.navs;
    }

    public final ImmutableJdkComp withInteger(int value) {
        if (this.integer == value) {
            return this;
        }
        return new ImmutableJdkComp(value, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs);
    }

    public final ImmutableJdkComp withString(String value) {
        if (this.string.equals(value)) {
            return this;
        }
        return new ImmutableJdkComp(this.integer, Objects.requireNonNull(value, "string"), this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs);
    }

    public final ImmutableJdkComp withBools(@Nullable Boolean value) {
        if (Objects.equals(this.bools, value)) {
            return this;
        }
        return new ImmutableJdkComp(this.integer, this.string, value, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs);
    }

    public final ImmutableJdkComp withStr(String ... elements) {
        List<String> newValue = ImmutableJdkComp.createUnmodifiableList(false, ImmutableJdkComp.createSafeList(Arrays.asList(elements)));
        return new ImmutableJdkComp(this.integer, this.string, this.bools, newValue, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs);
    }

    public final ImmutableJdkComp withStr(Iterable<String> elements) {
        if (this.str == elements) {
            return this;
        }
        List<String> newValue = ImmutableJdkComp.createUnmodifiableList(false, ImmutableJdkComp.createSafeList(elements));
        return new ImmutableJdkComp(this.integer, this.string, this.bools, newValue, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs);
    }

    public final ImmutableJdkComp withInts(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        Set<Integer> newValue = ImmutableJdkComp.createUnmodifiableSet(wrappedList);
        return new ImmutableJdkComp(this.integer, this.string, this.bools, this.str, newValue, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs);
    }

    public final ImmutableJdkComp withInts(Iterable<Integer> elements) {
        if (this.ints == elements) {
            return this;
        }
        Set<Integer> newValue = ImmutableJdkComp.createUnmodifiableSet(ImmutableJdkComp.createSafeList(elements));
        return new ImmutableJdkComp(this.integer, this.string, this.bools, this.str, newValue, this.arrayInts, this.arrayStrings, this.ords, this.pols, this.navs);
    }

    public final ImmutableJdkComp withArrayInts(int ... elements) {
        int[] newValue = (int[])elements.clone();
        return new ImmutableJdkComp(this.integer, this.string, this.bools, this.str, this.ints, newValue, this.arrayStrings, this.ords, this.pols, this.navs);
    }

    public final ImmutableJdkComp withArrayStrings(String ... elements) {
        String[] newValue = (String[])elements.clone();
        return new ImmutableJdkComp(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, newValue, this.ords, this.pols, this.navs);
    }

    public final ImmutableJdkComp withOrds(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        NavigableSet<Integer> newValue = ImmutableJdkComp.createUnmodifiableSortedSet(false, wrappedList);
        return new ImmutableJdkComp(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, newValue, this.pols, this.navs);
    }

    public final ImmutableJdkComp withOrds(Iterable<Integer> elements) {
        if (this.ords == elements) {
            return this;
        }
        NavigableSet<Integer> newValue = ImmutableJdkComp.createUnmodifiableSortedSet(false, ImmutableJdkComp.createSafeList(elements));
        return new ImmutableJdkComp(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, newValue, this.pols, this.navs);
    }

    public final ImmutableJdkComp withPols(RetentionPolicy ... elements) {
        Set<RetentionPolicy> newValue = ImmutableJdkComp.createUnmodifiableEnumSet(Arrays.asList(elements));
        return new ImmutableJdkComp(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, newValue, this.navs);
    }

    public final ImmutableJdkComp withPols(Iterable<RetentionPolicy> elements) {
        if (this.pols == elements) {
            return this;
        }
        Set<RetentionPolicy> newValue = ImmutableJdkComp.createUnmodifiableEnumSet(elements);
        return new ImmutableJdkComp(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, newValue, this.navs);
    }

    public final ImmutableJdkComp withNavs(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        NavigableSet<Integer> newValue = ImmutableJdkComp.createUnmodifiableSortedSet(true, wrappedList);
        return new ImmutableJdkComp(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, newValue);
    }

    public final ImmutableJdkComp withNavs(Iterable<Integer> elements) {
        if (this.navs == elements) {
            return this;
        }
        NavigableSet<Integer> newValue = ImmutableJdkComp.createUnmodifiableSortedSet(true, ImmutableJdkComp.createSafeList(elements));
        return new ImmutableJdkComp(this.integer, this.string, this.bools, this.str, this.ints, this.arrayInts, this.arrayStrings, this.ords, this.pols, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJdkComp && this.equalTo((ImmutableJdkComp)another);
    }

    private boolean equalTo(ImmutableJdkComp another) {
        return this.integer == another.integer && this.string.equals(another.string) && Objects.equals(this.bools, another.bools) && this.str.equals(another.str) && this.ints.equals(another.ints) && Arrays.equals(this.arrayInts, another.arrayInts) && Arrays.equals(this.arrayStrings, another.arrayStrings) && this.ords.equals(another.ords) && this.pols.equals(another.pols) && this.navs.equals(another.navs);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.integer;
        h = h * 17 + this.string.hashCode();
        h = h * 17 + Objects.hashCode(this.bools);
        h = h * 17 + this.str.hashCode();
        h = h * 17 + this.ints.hashCode();
        h = h * 17 + Arrays.hashCode(this.arrayInts);
        h = h * 17 + Arrays.hashCode(this.arrayStrings);
        h = h * 17 + this.ords.hashCode();
        h = h * 17 + this.pols.hashCode();
        h = h * 17 + this.navs.hashCode();
        return h;
    }

    public String toString() {
        return "JdkComp{integer=" + this.integer + ", string=" + this.string + ", bools=" + this.bools + ", str=" + this.str + ", ints=" + this.ints + ", arrayInts=" + Arrays.toString(this.arrayInts) + ", arrayStrings=" + Arrays.toString(this.arrayStrings) + ", ords=" + this.ords + ", pols=" + this.pols + ", navs=" + this.navs + "}";
    }

    public static ImmutableJdkComp copyOf(Companion.JdkComp instance) {
        if (instance instanceof ImmutableJdkComp) {
            return (ImmutableJdkComp)instance;
        }
        return ImmutableJdkComp.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> ArrayList<T> createSafeList(Iterable<? extends T> iterable) {
        ArrayList<T> list = iterable instanceof Collection ? new ArrayList<T>(((Collection)iterable).size()) : new ArrayList();
        for (T element : iterable) {
            list.add(Objects.requireNonNull(element, "element"));
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        ArrayList<T> list = ImmutableJdkComp.createSafeList(iterable);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    private static <T extends Comparable<T>> NavigableSet<T> createUnmodifiableSortedSet(boolean reverse, List<T> list) {
        TreeSet set = reverse ? new TreeSet(Collections.reverseOrder()) : new TreeSet();
        set.addAll(list);
        return Collections.unmodifiableNavigableSet(set);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INTEGER = 1L;
        private static final long INIT_BIT_STRING = 2L;
        private static final long INIT_BIT_ARRAY_INTS = 4L;
        private static final long INIT_BIT_ARRAY_STRINGS = 8L;
        private long initBits = 15L;
        private int integer;
        @Nullable
        private String string;
        @Nullable
        private Boolean bools;
        private ArrayList<String> strBuilder = new ArrayList();
        private ArrayList<Integer> intsBuilder = new ArrayList();
        @Nullable
        private int[] arrayInts;
        @Nullable
        private String[] arrayStrings;
        private ArrayList<Integer> ordsBuilder = new ArrayList();
        private EnumSet<RetentionPolicy> polsBuilder = EnumSet.noneOf(RetentionPolicy.class);
        private ArrayList<Integer> navsBuilder = new ArrayList();

        private Builder() {
        }

        public final Builder from(Companion.JdkComp instance) {
            Objects.requireNonNull(instance, "instance");
            this.integer(instance.integer());
            this.string(instance.string());
            Boolean boolsValue = instance.bools();
            if (boolsValue != null) {
                this.bools(boolsValue);
            }
            this.addAllStr(instance.str());
            this.addAllInts(instance.ints());
            this.arrayInts(instance.arrayInts());
            this.arrayStrings(instance.arrayStrings());
            this.addAllOrds(instance.ords());
            this.addAllPols(instance.pols());
            this.addAllNavs(instance.navs());
            return this;
        }

        public final Builder integer(int integer) {
            this.integer = integer;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder string(String string) {
            this.string = Objects.requireNonNull(string, "string");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder bools(@Nullable Boolean bools) {
            this.bools = bools;
            return this;
        }

        public final Builder addStr(String element) {
            this.strBuilder.add(Objects.requireNonNull(element, "str element"));
            return this;
        }

        public final Builder addStr(String ... elements) {
            for (String element : elements) {
                this.strBuilder.add(Objects.requireNonNull(element, "str element"));
            }
            return this;
        }

        public final Builder str(Iterable<String> elements) {
            this.strBuilder.clear();
            return this.addAllStr(elements);
        }

        public final Builder addAllStr(Iterable<String> elements) {
            for (String element : elements) {
                this.strBuilder.add(Objects.requireNonNull(element, "str element"));
            }
            return this;
        }

        public final Builder addInts(int element) {
            this.intsBuilder.add(element);
            return this;
        }

        public final Builder addInts(int ... elements) {
            for (int element : elements) {
                this.intsBuilder.add(element);
            }
            return this;
        }

        public final Builder ints(Iterable<Integer> elements) {
            this.intsBuilder.clear();
            return this.addAllInts(elements);
        }

        public final Builder addAllInts(Iterable<Integer> elements) {
            for (int element : elements) {
                this.intsBuilder.add(Objects.requireNonNull(Integer.valueOf(element), "ints element"));
            }
            return this;
        }

        public final Builder arrayInts(int ... elements) {
            this.arrayInts = (int[])elements.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder arrayStrings(String ... elements) {
            this.arrayStrings = (String[])elements.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder addOrds(int element) {
            this.ordsBuilder.add(element);
            return this;
        }

        public final Builder addOrds(int ... elements) {
            for (int element : elements) {
                this.ordsBuilder.add(element);
            }
            return this;
        }

        public final Builder ords(Iterable<Integer> elements) {
            this.ordsBuilder.clear();
            return this.addAllOrds(elements);
        }

        public final Builder addAllOrds(Iterable<Integer> elements) {
            for (int element : elements) {
                this.ordsBuilder.add(Objects.requireNonNull(Integer.valueOf(element), "ords element"));
            }
            return this;
        }

        public final Builder addPols(RetentionPolicy element) {
            this.polsBuilder.add(Objects.requireNonNull(element, "pols element"));
            return this;
        }

        public final Builder addPols(RetentionPolicy ... elements) {
            for (RetentionPolicy element : elements) {
                this.polsBuilder.add(Objects.requireNonNull(element, "pols element"));
            }
            return this;
        }

        public final Builder pols(Iterable<RetentionPolicy> elements) {
            this.polsBuilder.clear();
            return this.addAllPols(elements);
        }

        public final Builder addAllPols(Iterable<RetentionPolicy> elements) {
            for (RetentionPolicy element : elements) {
                this.polsBuilder.add(Objects.requireNonNull(element, "pols element"));
            }
            return this;
        }

        public final Builder addNavs(int element) {
            this.navsBuilder.add(element);
            return this;
        }

        public final Builder addNavs(int ... elements) {
            for (int element : elements) {
                this.navsBuilder.add(element);
            }
            return this;
        }

        public final Builder navs(Iterable<Integer> elements) {
            this.navsBuilder.clear();
            return this.addAllNavs(elements);
        }

        public final Builder addAllNavs(Iterable<Integer> elements) {
            for (int element : elements) {
                this.navsBuilder.add(Objects.requireNonNull(Integer.valueOf(element), "navs element"));
            }
            return this;
        }

        public ImmutableJdkComp build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJdkComp(this.integer, this.string, this.bools, ImmutableJdkComp.createUnmodifiableList(true, this.strBuilder), ImmutableJdkComp.createUnmodifiableSet(this.intsBuilder), this.arrayInts, this.arrayStrings, ImmutableJdkComp.createUnmodifiableSortedSet(false, ImmutableJdkComp.createSafeList(this.ordsBuilder)), ImmutableJdkComp.createUnmodifiableEnumSet(this.polsBuilder), ImmutableJdkComp.createUnmodifiableSortedSet(true, ImmutableJdkComp.createSafeList(this.navsBuilder)));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("integer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("string");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("arrayInts");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("arrayStrings");
            }
            return "Cannot build JdkComp, some of required attributes are not set " + attributes;
        }
    }
}

