/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.Companion;
import org.immutables.fixture.modifiable.ImmutableCompanion;

@ParametersAreNonnullByDefault
@NotThreadSafe
final class ModifiableCompanion
implements Companion {
    private static final long INIT_BIT_INTEGER = 1L;
    private static final long INIT_BIT_STRING = 2L;
    private static final long INIT_BIT_ARRAY_INTS = 4L;
    private static final long INIT_BIT_ARRAY_STRINGS = 8L;
    private long initBits = 15L;
    private int integer;
    private String string;
    @Nullable
    private Boolean bools;
    private final ArrayList<String> str = new ArrayList();
    private final LinkedHashSet<Integer> ints = new LinkedHashSet();
    private int[] arrayInts;
    private String[] arrayStrings;
    private final TreeSet<Integer> ords = new TreeSet();
    private final EnumSet<RetentionPolicy> pols = EnumSet.noneOf(RetentionPolicy.class);
    private final TreeSet<Integer> navs = new TreeSet(Collections.reverseOrder());
    private final Map<Long, Integer> just = new LinkedHashMap<Long, Integer>();
    private final TreeMap<Integer, String> ordsmap = new TreeMap();
    private final EnumMap<RetentionPolicy, Integer> polsmap = new EnumMap(RetentionPolicy.class);
    private final TreeMap<String, Integer> navsmap = new TreeMap(Collections.reverseOrder());

    private ModifiableCompanion() {
    }

    public static ModifiableCompanion create() {
        return new ModifiableCompanion();
    }

    @Override
    public final int integer() {
        if (!this.integerIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.integer;
    }

    @Override
    public final String string() {
        if (!this.stringIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.string;
    }

    @Override
    @Nullable
    public final Boolean bools() {
        return this.bools;
    }

    @Override
    public final List<String> str() {
        return this.str;
    }

    @Override
    public final Set<Integer> ints() {
        return this.ints;
    }

    @Override
    public final int[] arrayInts() {
        if (!this.arrayIntsIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.arrayInts;
    }

    @Override
    public final String[] arrayStrings() {
        if (!this.arrayStringsIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.arrayStrings;
    }

    @Override
    public final SortedSet<Integer> ords() {
        return this.ords;
    }

    @Override
    public final Set<RetentionPolicy> pols() {
        return this.pols;
    }

    @Override
    public final NavigableSet<Integer> navs() {
        return this.navs;
    }

    @Override
    public final Map<Long, Integer> just() {
        return this.just;
    }

    @Override
    public final SortedMap<Integer, String> ordsmap() {
        return this.ordsmap;
    }

    @Override
    public final Map<RetentionPolicy, Integer> polsmap() {
        return this.polsmap;
    }

    @Override
    public final NavigableMap<String, Integer> navsmap() {
        return this.navsmap;
    }

    public ModifiableCompanion clear() {
        this.initBits = 15L;
        this.integer = 0;
        this.string = null;
        this.bools = null;
        this.str.clear();
        this.ints.clear();
        this.arrayInts = null;
        this.arrayStrings = null;
        this.ords.clear();
        this.pols.clear();
        this.navs.clear();
        this.just.clear();
        this.ordsmap.clear();
        this.polsmap.clear();
        this.navsmap.clear();
        return this;
    }

    public ModifiableCompanion from(Companion instance) {
        Preconditions.checkNotNull((Object)instance, (Object)"instance");
        this.setInteger(instance.integer());
        this.setString(instance.string());
        Boolean boolsValue = instance.bools();
        if (boolsValue != null) {
            this.setBools(boolsValue);
        }
        this.addAllStr(instance.str());
        this.addAllInts(instance.ints());
        this.setArrayInts(instance.arrayInts());
        this.setArrayStrings(instance.arrayStrings());
        this.addAllOrds(instance.ords());
        this.addAllPols(instance.pols());
        this.addAllNavs(instance.navs());
        this.putAllJust(instance.just());
        this.putAllOrdsmap(instance.ordsmap());
        this.putAllPolsmap(instance.polsmap());
        this.putAllNavsmap(instance.navsmap());
        return this;
    }

    public ModifiableCompanion setInteger(int integer) {
        this.integer = integer;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public ModifiableCompanion setString(String string) {
        this.string = (String)Preconditions.checkNotNull((Object)string, (Object)"string");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public ModifiableCompanion setBools(@Nullable Boolean bools) {
        this.bools = bools;
        return this;
    }

    public ModifiableCompanion addStr(String element) {
        this.str.add((String)Preconditions.checkNotNull((Object)element, (Object)"str element"));
        return this;
    }

    public ModifiableCompanion addStr(String ... elements) {
        for (String element : elements) {
            this.str.add((String)Preconditions.checkNotNull((Object)element, (Object)"str element"));
        }
        return this;
    }

    public ModifiableCompanion setStr(Iterable<String> elements) {
        this.str.clear();
        return this.addAllStr(elements);
    }

    public ModifiableCompanion addAllStr(Iterable<String> elements) {
        for (String element : elements) {
            this.str.add((String)Preconditions.checkNotNull((Object)element, (Object)"str element"));
        }
        return this;
    }

    public ModifiableCompanion addInts(int element) {
        this.ints.add(element);
        return this;
    }

    public ModifiableCompanion addInts(int ... elements) {
        for (int element : elements) {
            this.ints.add(element);
        }
        return this;
    }

    public ModifiableCompanion setInts(Iterable<Integer> elements) {
        this.ints.clear();
        return this.addAllInts(elements);
    }

    public ModifiableCompanion addAllInts(Iterable<Integer> elements) {
        for (int element : elements) {
            this.ints.add(element);
        }
        return this;
    }

    public ModifiableCompanion setArrayInts(int ... elements) {
        this.arrayInts = (int[])elements.clone();
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public ModifiableCompanion setArrayStrings(String ... elements) {
        this.arrayStrings = (String[])elements.clone();
        this.initBits &= 0xFFFFFFFFFFFFFFF7L;
        return this;
    }

    public ModifiableCompanion addOrds(int element) {
        this.ords.add(element);
        return this;
    }

    public ModifiableCompanion addOrds(int ... elements) {
        for (int element : elements) {
            this.ords.add(element);
        }
        return this;
    }

    public ModifiableCompanion setOrds(Iterable<Integer> elements) {
        this.ords.clear();
        return this.addAllOrds(elements);
    }

    public ModifiableCompanion addAllOrds(Iterable<Integer> elements) {
        for (int element : elements) {
            this.ords.add(element);
        }
        return this;
    }

    public ModifiableCompanion addPols(RetentionPolicy element) {
        this.pols.add((RetentionPolicy)((Object)Preconditions.checkNotNull((Object)((Object)element), (Object)"pols element")));
        return this;
    }

    public ModifiableCompanion addPols(RetentionPolicy ... elements) {
        for (RetentionPolicy element : elements) {
            this.pols.add((RetentionPolicy)((Object)Preconditions.checkNotNull((Object)((Object)element), (Object)"pols element")));
        }
        return this;
    }

    public ModifiableCompanion setPols(Iterable<RetentionPolicy> elements) {
        this.pols.clear();
        return this.addAllPols(elements);
    }

    public ModifiableCompanion addAllPols(Iterable<RetentionPolicy> elements) {
        for (RetentionPolicy element : elements) {
            this.pols.add((RetentionPolicy)((Object)Preconditions.checkNotNull((Object)((Object)element), (Object)"pols element")));
        }
        return this;
    }

    public ModifiableCompanion addNavs(int element) {
        this.navs.add(element);
        return this;
    }

    public ModifiableCompanion addNavs(int ... elements) {
        for (int element : elements) {
            this.navs.add(element);
        }
        return this;
    }

    public ModifiableCompanion setNavs(Iterable<Integer> elements) {
        this.navs.clear();
        return this.addAllNavs(elements);
    }

    public ModifiableCompanion addAllNavs(Iterable<Integer> elements) {
        for (int element : elements) {
            this.navs.add(element);
        }
        return this;
    }

    public ModifiableCompanion putJust(long key, int value) {
        this.just.put(key, value);
        return this;
    }

    public ModifiableCompanion setJust(Map<Long, ? extends Integer> entries) {
        this.just.clear();
        return this.putAllJust(entries);
    }

    public ModifiableCompanion putAllJust(Map<Long, ? extends Integer> entries) {
        for (Map.Entry<Long, ? extends Integer> entry : entries.entrySet()) {
            this.just.put((Long)Preconditions.checkNotNull((Object)entry.getKey(), (Object)"just key"), (Integer)Preconditions.checkNotNull((Object)entry.getValue(), (Object)"just value"));
        }
        return this;
    }

    public ModifiableCompanion putOrdsmap(int key, String value) {
        this.ordsmap.put(key, (String)Preconditions.checkNotNull((Object)value, (Object)"ordsmap value"));
        return this;
    }

    public ModifiableCompanion setOrdsmap(Map<Integer, ? extends String> entries) {
        this.ordsmap.clear();
        return this.putAllOrdsmap(entries);
    }

    public ModifiableCompanion putAllOrdsmap(Map<Integer, ? extends String> entries) {
        for (Map.Entry<Integer, ? extends String> entry : entries.entrySet()) {
            this.ordsmap.put((Integer)Preconditions.checkNotNull((Object)entry.getKey(), (Object)"ordsmap key"), (String)Preconditions.checkNotNull((Object)entry.getValue(), (Object)"ordsmap value"));
        }
        return this;
    }

    public ModifiableCompanion putPolsmap(RetentionPolicy key, int value) {
        this.polsmap.put((RetentionPolicy)((Enum)Preconditions.checkNotNull((Object)((Object)key), (Object)"polsmap key")), value);
        return this;
    }

    public ModifiableCompanion setPolsmap(Map<RetentionPolicy, ? extends Integer> entries) {
        this.polsmap.clear();
        return this.putAllPolsmap(entries);
    }

    public ModifiableCompanion putAllPolsmap(Map<RetentionPolicy, ? extends Integer> entries) {
        for (Map.Entry<RetentionPolicy, ? extends Integer> entry : entries.entrySet()) {
            this.polsmap.put((RetentionPolicy)((Enum)Preconditions.checkNotNull((Object)((Object)entry.getKey()), (Object)"polsmap key")), (Integer)Preconditions.checkNotNull((Object)entry.getValue(), (Object)"polsmap value"));
        }
        return this;
    }

    public ModifiableCompanion putNavsmap(String key, int value) {
        this.navsmap.put((String)Preconditions.checkNotNull((Object)key, (Object)"navsmap key"), value);
        return this;
    }

    public ModifiableCompanion setNavsmap(Map<String, ? extends Integer> entries) {
        this.navsmap.clear();
        return this.putAllNavsmap(entries);
    }

    public ModifiableCompanion putAllNavsmap(Map<String, ? extends Integer> entries) {
        for (Map.Entry<String, ? extends Integer> entry : entries.entrySet()) {
            this.navsmap.put((String)Preconditions.checkNotNull((Object)entry.getKey(), (Object)"navsmap key"), (Integer)Preconditions.checkNotNull((Object)entry.getValue(), (Object)"navsmap value"));
        }
        return this;
    }

    public final boolean integerIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    public final boolean stringIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    public final boolean arrayIntsIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    public final boolean arrayStringsIsSet() {
        return (this.initBits & 8L) == 0L;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList attributes = Lists.newArrayList();
        if (!this.integerIsSet()) {
            attributes.add("integer");
        }
        if (!this.stringIsSet()) {
            attributes.add("string");
        }
        if (!this.arrayIntsIsSet()) {
            attributes.add("arrayInts");
        }
        if (!this.arrayStringsIsSet()) {
            attributes.add("arrayStrings");
        }
        return "Companion in not initialized, some of the required attributes are not set " + attributes;
    }

    public final ImmutableCompanion toImmutable() {
        this.checkRequiredAttributes();
        return ImmutableCompanion.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableCompanion)) {
            return false;
        }
        ModifiableCompanion o = (ModifiableCompanion)another;
        if (!this.isInitialized() || !o.isInitialized()) {
            return false;
        }
        return this.equalTo(o);
    }

    private boolean equalTo(ModifiableCompanion another) {
        return this.integer == another.integer && this.string.equals(another.string) && Objects.equal((Object)this.bools, (Object)another.bools) && this.str.equals(another.str) && this.ints.equals(another.ints) && Arrays.equals(this.arrayInts, another.arrayInts) && Arrays.equals(this.arrayStrings, another.arrayStrings) && this.ords.equals(another.ords) && this.pols.equals(another.pols) && this.navs.equals(another.navs) && this.just.equals(another.just) && this.ordsmap.equals(another.ordsmap) && this.polsmap.equals((Object)another.polsmap) && this.navsmap.equals(another.navsmap);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.integer;
        h = h * 17 + this.string.hashCode();
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.bools});
        h = h * 17 + this.str.hashCode();
        h = h * 17 + this.ints.hashCode();
        h = h * 17 + Arrays.hashCode(this.arrayInts);
        h = h * 17 + Arrays.hashCode(this.arrayStrings);
        h = h * 17 + this.ords.hashCode();
        h = h * 17 + this.pols.hashCode();
        h = h * 17 + this.navs.hashCode();
        h = h * 17 + this.just.hashCode();
        h = h * 17 + this.ordsmap.hashCode();
        h = h * 17 + this.polsmap.hashCode();
        h = h * 17 + this.navsmap.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModifiableCompanion").add("integer", this.integerIsSet() ? Integer.valueOf(this.integer) : "?").add("string", (Object)(this.stringIsSet() ? this.string : "?")).add("bools", (Object)this.bools).add("str", this.str).add("ints", this.ints).add("arrayInts", (Object)(this.arrayIntsIsSet() ? Arrays.toString(this.arrayInts) : "?")).add("arrayStrings", (Object)(this.arrayStringsIsSet() ? Arrays.toString(this.arrayStrings) : "?")).add("ords", this.ords).add("pols", this.pols).add("navs", this.navs).add("just", this.just).add("ordsmap", this.ordsmap).add("polsmap", this.polsmap).add("navsmap", this.navsmap).toString();
    }
}

