/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.Companion;

@ParametersAreNonnullByDefault
@NotThreadSafe
public final class ModifiableExtra
implements Companion.Extra {
    private final HashMultiset<String> bag = HashMultiset.create();
    private final ArrayListMultimap<Integer, String> index = ArrayListMultimap.create();
    private final ArrayListMultimap<Integer, String> indexList = ArrayListMultimap.create();
    private final HashMultimap<Integer, String> indexSet = HashMultimap.create();
    private final HashBiMap<Integer, String> biMap = HashBiMap.create();

    private ModifiableExtra() {
    }

    public static ModifiableExtra create(Iterable<String> bag, Multimap<Integer, ? extends String> index, Multimap<Integer, ? extends String> indexList, Multimap<Integer, ? extends String> indexSet, Map<Integer, ? extends String> biMap) {
        return new ModifiableExtra().addAllBag(bag).putAllIndex(index).putAllIndexList(indexList).putAllIndexSet(indexSet).putAllBiMap(biMap);
    }

    public static ModifiableExtra create() {
        return new ModifiableExtra();
    }

    @Override
    public final Multiset<String> bag() {
        return this.bag;
    }

    @Override
    public final Multimap<Integer, String> index() {
        return this.index;
    }

    @Override
    public final ListMultimap<Integer, String> indexList() {
        return this.indexList;
    }

    @Override
    public final SetMultimap<Integer, String> indexSet() {
        return this.indexSet;
    }

    @Override
    public final BiMap<Integer, String> biMap() {
        return this.biMap;
    }

    public ModifiableExtra clear() {
        this.bag.clear();
        this.index.clear();
        this.indexList.clear();
        this.indexSet.clear();
        this.biMap.clear();
        return this;
    }

    public ModifiableExtra from(Companion.Extra instance) {
        Preconditions.checkNotNull((Object)instance, (Object)"instance");
        this.addAllBag((Iterable<String>)instance.bag());
        this.putAllIndex(instance.index());
        this.putAllIndexList((Multimap<Integer, ? extends String>)instance.indexList());
        this.putAllIndexSet((Multimap<Integer, ? extends String>)instance.indexSet());
        this.putAllBiMap((Map<Integer, ? extends String>)instance.biMap());
        return this;
    }

    public ModifiableExtra addBag(String element) {
        this.bag.add(Preconditions.checkNotNull((Object)element, (Object)"bag element"));
        return this;
    }

    public ModifiableExtra addBag(String ... elements) {
        for (String element : elements) {
            this.bag.add(Preconditions.checkNotNull((Object)element, (Object)"bag element"));
        }
        return this;
    }

    public ModifiableExtra setBag(Iterable<String> elements) {
        this.bag.clear();
        return this.addAllBag(elements);
    }

    public ModifiableExtra addAllBag(Iterable<String> elements) {
        for (String element : elements) {
            this.bag.add(Preconditions.checkNotNull((Object)element, (Object)"bag element"));
        }
        return this;
    }

    public ModifiableExtra putIndex(int key, String ... values) {
        this.index.putAll((Object)key, Arrays.asList(values));
        return this;
    }

    public ModifiableExtra putAllIndex(int key, Iterable<String> values) {
        this.index.putAll((Object)key, values);
        return this;
    }

    public ModifiableExtra putIndex(int key, String value) {
        this.index.put((Object)key, Preconditions.checkNotNull((Object)value, (Object)"index value"));
        return this;
    }

    public ModifiableExtra setIndex(Multimap<Integer, ? extends String> entries) {
        this.index.clear();
        return this.putAllIndex(entries);
    }

    public ModifiableExtra putAllIndex(Multimap<Integer, ? extends String> entries) {
        for (Map.Entry entry : entries.entries()) {
            this.index.put(Preconditions.checkNotNull(entry.getKey(), (Object)"index key"), Preconditions.checkNotNull(entry.getValue(), (Object)"index value"));
        }
        return this;
    }

    public ModifiableExtra putIndexList(int key, String ... values) {
        this.indexList.putAll((Object)key, Arrays.asList(values));
        return this;
    }

    public ModifiableExtra putAllIndexList(int key, Iterable<String> values) {
        this.indexList.putAll((Object)key, values);
        return this;
    }

    public ModifiableExtra putIndexList(int key, String value) {
        this.indexList.put((Object)key, Preconditions.checkNotNull((Object)value, (Object)"indexList value"));
        return this;
    }

    public ModifiableExtra setIndexList(Multimap<Integer, ? extends String> entries) {
        this.indexList.clear();
        return this.putAllIndexList(entries);
    }

    public ModifiableExtra putAllIndexList(Multimap<Integer, ? extends String> entries) {
        for (Map.Entry entry : entries.entries()) {
            this.indexList.put(Preconditions.checkNotNull(entry.getKey(), (Object)"indexList key"), Preconditions.checkNotNull(entry.getValue(), (Object)"indexList value"));
        }
        return this;
    }

    public ModifiableExtra putIndexSet(int key, String ... values) {
        this.indexSet.putAll((Object)key, Arrays.asList(values));
        return this;
    }

    public ModifiableExtra putAllIndexSet(int key, Iterable<String> values) {
        this.indexSet.putAll((Object)key, values);
        return this;
    }

    public ModifiableExtra putIndexSet(int key, String value) {
        this.indexSet.put((Object)key, Preconditions.checkNotNull((Object)value, (Object)"indexSet value"));
        return this;
    }

    public ModifiableExtra setIndexSet(Multimap<Integer, ? extends String> entries) {
        this.indexSet.clear();
        return this.putAllIndexSet(entries);
    }

    public ModifiableExtra putAllIndexSet(Multimap<Integer, ? extends String> entries) {
        for (Map.Entry entry : entries.entries()) {
            this.indexSet.put(Preconditions.checkNotNull(entry.getKey(), (Object)"indexSet key"), Preconditions.checkNotNull(entry.getValue(), (Object)"indexSet value"));
        }
        return this;
    }

    public ModifiableExtra putBiMap(int key, String value) {
        this.biMap.put((Object)key, Preconditions.checkNotNull((Object)value, (Object)"biMap value"));
        return this;
    }

    public ModifiableExtra setBiMap(Map<Integer, ? extends String> entries) {
        this.biMap.clear();
        return this.putAllBiMap(entries);
    }

    public ModifiableExtra putAllBiMap(Map<Integer, ? extends String> entries) {
        for (Map.Entry<Integer, ? extends String> entry : entries.entrySet()) {
            this.biMap.put(Preconditions.checkNotNull((Object)entry.getKey(), (Object)"biMap key"), Preconditions.checkNotNull((Object)entry.getValue(), (Object)"biMap value"));
        }
        return this;
    }

    public final boolean isInitialized() {
        return true;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableExtra)) {
            return false;
        }
        ModifiableExtra o = (ModifiableExtra)another;
        return this.equalTo(o);
    }

    private boolean equalTo(ModifiableExtra another) {
        return this.bag.equals(another.bag) && this.index.equals(another.index) && this.indexList.equals(another.indexList) && this.indexSet.equals(another.indexSet) && this.biMap.equals(another.biMap);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.bag.hashCode();
        h = h * 17 + this.index.hashCode();
        h = h * 17 + this.indexList.hashCode();
        h = h * 17 + this.indexSet.hashCode();
        h = h * 17 + this.biMap.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModifiableExtra").add("bag", this.bag).add("index", this.index).add("indexList", this.indexList).add("indexSet", this.indexSet).add("biMap", this.biMap).toString();
    }
}

