/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.Companion;
import org.immutables.fixture.modifiable.ImmutableJdkComp;

@ParametersAreNonnullByDefault
@NotThreadSafe
public final class ModifiableJdkComp
implements Companion.JdkComp {
    private static final long INIT_BIT_INTEGER = 1L;
    private static final long INIT_BIT_STRING = 2L;
    private static final long INIT_BIT_ARRAY_INTS = 4L;
    private static final long INIT_BIT_ARRAY_STRINGS = 8L;
    private long initBits = 15L;
    private int integer;
    private String string;
    @Nullable
    private Boolean bools;
    private final ArrayList<String> str = new ArrayList();
    private final LinkedHashSet<Integer> ints = new LinkedHashSet();
    private int[] arrayInts;
    private String[] arrayStrings;
    private final TreeSet<Integer> ords = new TreeSet();
    private final EnumSet<RetentionPolicy> pols = EnumSet.noneOf(RetentionPolicy.class);
    private final TreeSet<Integer> navs = new TreeSet(Collections.reverseOrder());

    private ModifiableJdkComp() {
    }

    public static ModifiableJdkComp create() {
        return new ModifiableJdkComp();
    }

    @Override
    public final int integer() {
        if (!this.integerIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.integer;
    }

    @Override
    public final String string() {
        if (!this.stringIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.string;
    }

    @Override
    @Nullable
    public final Boolean bools() {
        return this.bools;
    }

    @Override
    public final List<String> str() {
        return this.str;
    }

    @Override
    public final Set<Integer> ints() {
        return this.ints;
    }

    @Override
    public final int[] arrayInts() {
        if (!this.arrayIntsIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.arrayInts;
    }

    @Override
    public final String[] arrayStrings() {
        if (!this.arrayStringsIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.arrayStrings;
    }

    @Override
    public final SortedSet<Integer> ords() {
        return this.ords;
    }

    @Override
    public final Set<RetentionPolicy> pols() {
        return this.pols;
    }

    @Override
    public final NavigableSet<Integer> navs() {
        return this.navs;
    }

    public ModifiableJdkComp clear() {
        this.initBits = 15L;
        this.integer = 0;
        this.string = null;
        this.bools = null;
        this.str.clear();
        this.ints.clear();
        this.arrayInts = null;
        this.arrayStrings = null;
        this.ords.clear();
        this.pols.clear();
        this.navs.clear();
        return this;
    }

    public ModifiableJdkComp from(Companion.JdkComp instance) {
        Objects.requireNonNull(instance, "instance");
        this.setInteger(instance.integer());
        this.setString(instance.string());
        Boolean boolsValue = instance.bools();
        if (boolsValue != null) {
            this.setBools(boolsValue);
        }
        this.addAllStr(instance.str());
        this.addAllInts(instance.ints());
        this.setArrayInts(instance.arrayInts());
        this.setArrayStrings(instance.arrayStrings());
        this.addAllOrds(instance.ords());
        this.addAllPols(instance.pols());
        this.addAllNavs(instance.navs());
        return this;
    }

    public ModifiableJdkComp setInteger(int integer) {
        this.integer = integer;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public ModifiableJdkComp setString(String string) {
        this.string = Objects.requireNonNull(string, "string");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public ModifiableJdkComp setBools(@Nullable Boolean bools) {
        this.bools = bools;
        return this;
    }

    public ModifiableJdkComp addStr(String element) {
        this.str.add(Objects.requireNonNull(element, "str element"));
        return this;
    }

    public ModifiableJdkComp addStr(String ... elements) {
        for (String element : elements) {
            this.str.add(Objects.requireNonNull(element, "str element"));
        }
        return this;
    }

    public ModifiableJdkComp setStr(Iterable<String> elements) {
        this.str.clear();
        return this.addAllStr(elements);
    }

    public ModifiableJdkComp addAllStr(Iterable<String> elements) {
        for (String element : elements) {
            this.str.add(Objects.requireNonNull(element, "str element"));
        }
        return this;
    }

    public ModifiableJdkComp addInts(int element) {
        this.ints.add(element);
        return this;
    }

    public ModifiableJdkComp addInts(int ... elements) {
        for (int element : elements) {
            this.ints.add(element);
        }
        return this;
    }

    public ModifiableJdkComp setInts(Iterable<Integer> elements) {
        this.ints.clear();
        return this.addAllInts(elements);
    }

    public ModifiableJdkComp addAllInts(Iterable<Integer> elements) {
        for (int element : elements) {
            this.ints.add(element);
        }
        return this;
    }

    public ModifiableJdkComp setArrayInts(int ... elements) {
        this.arrayInts = (int[])elements.clone();
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public ModifiableJdkComp setArrayStrings(String ... elements) {
        this.arrayStrings = (String[])elements.clone();
        this.initBits &= 0xFFFFFFFFFFFFFFF7L;
        return this;
    }

    public ModifiableJdkComp addOrds(int element) {
        this.ords.add(element);
        return this;
    }

    public ModifiableJdkComp addOrds(int ... elements) {
        for (int element : elements) {
            this.ords.add(element);
        }
        return this;
    }

    public ModifiableJdkComp setOrds(Iterable<Integer> elements) {
        this.ords.clear();
        return this.addAllOrds(elements);
    }

    public ModifiableJdkComp addAllOrds(Iterable<Integer> elements) {
        for (int element : elements) {
            this.ords.add(element);
        }
        return this;
    }

    public ModifiableJdkComp addPols(RetentionPolicy element) {
        this.pols.add(Objects.requireNonNull(element, "pols element"));
        return this;
    }

    public ModifiableJdkComp addPols(RetentionPolicy ... elements) {
        for (RetentionPolicy element : elements) {
            this.pols.add(Objects.requireNonNull(element, "pols element"));
        }
        return this;
    }

    public ModifiableJdkComp setPols(Iterable<RetentionPolicy> elements) {
        this.pols.clear();
        return this.addAllPols(elements);
    }

    public ModifiableJdkComp addAllPols(Iterable<RetentionPolicy> elements) {
        for (RetentionPolicy element : elements) {
            this.pols.add(Objects.requireNonNull(element, "pols element"));
        }
        return this;
    }

    public ModifiableJdkComp addNavs(int element) {
        this.navs.add(element);
        return this;
    }

    public ModifiableJdkComp addNavs(int ... elements) {
        for (int element : elements) {
            this.navs.add(element);
        }
        return this;
    }

    public ModifiableJdkComp setNavs(Iterable<Integer> elements) {
        this.navs.clear();
        return this.addAllNavs(elements);
    }

    public ModifiableJdkComp addAllNavs(Iterable<Integer> elements) {
        for (int element : elements) {
            this.navs.add(element);
        }
        return this;
    }

    public final boolean integerIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    public final boolean stringIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    public final boolean arrayIntsIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    public final boolean arrayStringsIsSet() {
        return (this.initBits & 8L) == 0L;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.integerIsSet()) {
            attributes.add("integer");
        }
        if (!this.stringIsSet()) {
            attributes.add("string");
        }
        if (!this.arrayIntsIsSet()) {
            attributes.add("arrayInts");
        }
        if (!this.arrayStringsIsSet()) {
            attributes.add("arrayStrings");
        }
        return "JdkComp in not initialized, some of the required attributes are not set " + attributes;
    }

    public final ImmutableJdkComp toImmutable() {
        this.checkRequiredAttributes();
        return ImmutableJdkComp.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableJdkComp)) {
            return false;
        }
        ModifiableJdkComp o = (ModifiableJdkComp)another;
        if (!this.isInitialized() || !o.isInitialized()) {
            return false;
        }
        return this.equalTo(o);
    }

    private boolean equalTo(ModifiableJdkComp another) {
        return this.integer == another.integer && this.string.equals(another.string) && Objects.equals(this.bools, another.bools) && this.str.equals(another.str) && this.ints.equals(another.ints) && Arrays.equals(this.arrayInts, another.arrayInts) && Arrays.equals(this.arrayStrings, another.arrayStrings) && this.ords.equals(another.ords) && this.pols.equals(another.pols) && this.navs.equals(another.navs);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.integer;
        h = h * 17 + this.string.hashCode();
        h = h * 17 + Objects.hashCode(this.bools);
        h = h * 17 + this.str.hashCode();
        h = h * 17 + this.ints.hashCode();
        h = h * 17 + Arrays.hashCode(this.arrayInts);
        h = h * 17 + Arrays.hashCode(this.arrayStrings);
        h = h * 17 + this.ords.hashCode();
        h = h * 17 + this.pols.hashCode();
        h = h * 17 + this.navs.hashCode();
        return h;
    }

    public String toString() {
        return "ModifiableJdkComp{integer=" + (this.integerIsSet() ? Integer.valueOf(this.integer) : "?") + ", string=" + (this.stringIsSet() ? this.string : "?") + ", bools=" + this.bools + ", str=" + this.str + ", ints=" + this.ints + ", arrayInts=" + (this.arrayIntsIsSet() ? Arrays.toString(this.arrayInts) : "?") + ", arrayStrings=" + (this.arrayStringsIsSet() ? Arrays.toString(this.arrayStrings) : "?") + ", ords=" + this.ords + ", pols=" + this.pols + ", navs=" + this.navs + "}";
    }

    private static <T> ArrayList<T> createSafeList(Iterable<? extends T> iterable) {
        ArrayList<T> list = iterable instanceof Collection ? new ArrayList<T>(((Collection)iterable).size()) : new ArrayList();
        for (T element : iterable) {
            list.add(Objects.requireNonNull(element, "element"));
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        ArrayList<T> list = ModifiableJdkComp.createSafeList(iterable);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    private static <T extends Comparable<T>> NavigableSet<T> createUnmodifiableSortedSet(boolean reverse, List<T> list) {
        TreeSet set = reverse ? new TreeSet(Collections.reverseOrder()) : new TreeSet();
        set.addAll(list);
        return Collections.unmodifiableNavigableSet(set);
    }
}

