/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.Companion;

@ParametersAreNonnullByDefault
@NotThreadSafe
public class ModifiableSmall
implements Companion.Small {
    private static final long INIT_BIT_FIRST = 1L;
    private static final long INIT_BIT_SECOND = 2L;
    private long initBits = 3L;
    private int first;
    private String second;

    public ModifiableSmall(int first, String second) {
        this.setFirst(first);
        this.setSecond(second);
    }

    public ModifiableSmall() {
    }

    @Override
    public final int first() {
        if (!this.firstIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.first;
    }

    @Override
    public final String second() {
        if (!this.secondIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.second;
    }

    public ModifiableSmall clear() {
        this.initBits = 3L;
        this.first = 0;
        this.second = null;
        return this;
    }

    public ModifiableSmall from(Companion.Small instance) {
        Preconditions.checkNotNull((Object)instance, (Object)"instance");
        this.setFirst(instance.first());
        this.setSecond(instance.second());
        return this;
    }

    public ModifiableSmall setFirst(int first) {
        this.first = first;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public ModifiableSmall setSecond(String second) {
        this.second = (String)Preconditions.checkNotNull((Object)second, (Object)"second");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public final boolean firstIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    public final boolean secondIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList attributes = Lists.newArrayList();
        if (!this.firstIsSet()) {
            attributes.add("first");
        }
        if (!this.secondIsSet()) {
            attributes.add("second");
        }
        return "Small in not initialized, some of the required attributes are not set " + attributes;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableSmall)) {
            return false;
        }
        ModifiableSmall o = (ModifiableSmall)another;
        if (!this.isInitialized() || !o.isInitialized()) {
            return false;
        }
        return this.equalTo(o);
    }

    private boolean equalTo(ModifiableSmall another) {
        return this.first == another.first && this.second.equals(another.second);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.first;
        h = h * 17 + this.second.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModifiableSmall").add("first", this.firstIsSet() ? Integer.valueOf(this.first) : "?").add("second", (Object)(this.secondIsSet() ? this.second : "?")).toString();
    }
}

