/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nested;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.nested.ImmutableInnerNested;
import org.immutables.fixture.nested.InnerNested;

@ParametersAreNonnullByDefault
public final class GsonAdaptersInnerNested
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (NestedTypeAdapter.adapts(type)) {
            return new NestedTypeAdapter(gson);
        }
        if (InnerNestedTypeAdapter.adapts(type)) {
            return new InnerNestedTypeAdapter(gson);
        }
        if (InnerTypeAdapter.adapts(type)) {
            return new InnerTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersInnerNested(Nested, InnerNested, Inner)";
    }

    private static class InnerTypeAdapter
    extends TypeAdapter<InnerNested.Inner> {
        private static final TypeToken<InnerNested.Inner> INNER_ABSTRACT = TypeToken.get(InnerNested.Inner.class);
        private static final TypeToken<ImmutableInnerNested.Inner> INNER_IMMUTABLE = TypeToken.get(ImmutableInnerNested.Inner.class);

        InnerTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return INNER_ABSTRACT.equals(type) || INNER_IMMUTABLE.equals(type);
        }

        public void write(JsonWriter out, InnerNested.Inner value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeInner(out, value);
            }
        }

        public InnerNested.Inner read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readInner(in);
        }

        private void writeInner(JsonWriter out, InnerNested.Inner instance) throws IOException {
            out.beginObject();
            out.endObject();
        }

        private InnerNested.Inner readInner(JsonReader in) throws IOException {
            ImmutableInnerNested.Inner.Builder builder = ImmutableInnerNested.Inner.builder();
            in.skipValue();
            return builder.build();
        }
    }

    private static class InnerNestedTypeAdapter
    extends TypeAdapter<InnerNested> {
        private static final TypeToken<InnerNested> INNER_NESTED_ABSTRACT = TypeToken.get(InnerNested.class);
        private static final TypeToken<ImmutableInnerNested> INNER_NESTED_IMMUTABLE = TypeToken.get(ImmutableInnerNested.class);

        InnerNestedTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return INNER_NESTED_ABSTRACT.equals(type) || INNER_NESTED_IMMUTABLE.equals(type);
        }

        public void write(JsonWriter out, InnerNested value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeInnerNested(out, value);
            }
        }

        public InnerNested read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readInnerNested(in);
        }

        private void writeInnerNested(JsonWriter out, InnerNested instance) throws IOException {
            out.beginObject();
            out.endObject();
        }

        private InnerNested readInnerNested(JsonReader in) throws IOException {
            ImmutableInnerNested.Builder builder = ImmutableInnerNested.builder();
            in.skipValue();
            return builder.build();
        }
    }

    private static class NestedTypeAdapter
    extends TypeAdapter<InnerNested.Nested> {
        private static final TypeToken<InnerNested.Nested> NESTED_ABSTRACT = TypeToken.get(InnerNested.Nested.class);
        private static final TypeToken<ImmutableInnerNested.Nested> NESTED_IMMUTABLE = TypeToken.get(ImmutableInnerNested.Nested.class);

        NestedTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return NESTED_ABSTRACT.equals(type) || NESTED_IMMUTABLE.equals(type);
        }

        public void write(JsonWriter out, InnerNested.Nested value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeNested(out, value);
            }
        }

        public InnerNested.Nested read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readNested(in);
        }

        private void writeNested(JsonWriter out, InnerNested.Nested instance) throws IOException {
            out.beginObject();
            out.endObject();
        }

        private InnerNested.Nested readNested(JsonReader in) throws IOException {
            ImmutableInnerNested.Nested.Builder builder = ImmutableInnerNested.Nested.builder();
            in.skipValue();
            return builder.build();
        }
    }
}

