/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nested;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.nested.ImmutableAbra;
import org.immutables.fixture.nested.ImmutableCadabra;
import org.immutables.fixture.nested.ImmutableDabra;
import org.immutables.fixture.nested.NonGrouped;

@ParametersAreNonnullByDefault
public final class GsonAdaptersNonGrouped
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (DabraTypeAdapter.adapts(type)) {
            return new DabraTypeAdapter(gson);
        }
        if (AbraTypeAdapter.adapts(type)) {
            return new AbraTypeAdapter(gson);
        }
        if (CadabraTypeAdapter.adapts(type)) {
            return new CadabraTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersNonGrouped(Dabra, Abra, Cadabra)";
    }

    private static class CadabraTypeAdapter
    extends TypeAdapter<NonGrouped.Cadabra> {
        private static final TypeToken<NonGrouped.Cadabra> CADABRA_ABSTRACT = TypeToken.get(NonGrouped.Cadabra.class);
        private static final TypeToken<ImmutableCadabra> CADABRA_IMMUTABLE = TypeToken.get(ImmutableCadabra.class);

        CadabraTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return CADABRA_ABSTRACT.equals(type) || CADABRA_IMMUTABLE.equals(type);
        }

        public void write(JsonWriter out, NonGrouped.Cadabra value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeCadabra(out, value);
            }
        }

        public NonGrouped.Cadabra read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readCadabra(in);
        }

        private void writeCadabra(JsonWriter out, NonGrouped.Cadabra instance) throws IOException {
            out.beginObject();
            out.endObject();
        }

        private NonGrouped.Cadabra readCadabra(JsonReader in) throws IOException {
            in.skipValue();
            return ImmutableCadabra.of();
        }
    }

    private static class AbraTypeAdapter
    extends TypeAdapter<NonGrouped.Abra> {
        private static final TypeToken<NonGrouped.Abra> ABRA_ABSTRACT = TypeToken.get(NonGrouped.Abra.class);
        private static final TypeToken<ImmutableAbra> ABRA_IMMUTABLE = TypeToken.get(ImmutableAbra.class);

        AbraTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return ABRA_ABSTRACT.equals(type) || ABRA_IMMUTABLE.equals(type);
        }

        public void write(JsonWriter out, NonGrouped.Abra value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeAbra(out, value);
            }
        }

        public NonGrouped.Abra read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readAbra(in);
        }

        private void writeAbra(JsonWriter out, NonGrouped.Abra instance) throws IOException {
            out.beginObject();
            out.endObject();
        }

        private NonGrouped.Abra readAbra(JsonReader in) throws IOException {
            ImmutableAbra.Builder builder = ImmutableAbra.builder();
            in.skipValue();
            return builder.build();
        }
    }

    private static class DabraTypeAdapter
    extends TypeAdapter<NonGrouped.Dabra> {
        private static final TypeToken<NonGrouped.Dabra> DABRA_ABSTRACT = TypeToken.get(NonGrouped.Dabra.class);
        private static final TypeToken<ImmutableDabra> DABRA_IMMUTABLE = TypeToken.get(ImmutableDabra.class);

        DabraTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return DABRA_ABSTRACT.equals(type) || DABRA_IMMUTABLE.equals(type);
        }

        public void write(JsonWriter out, NonGrouped.Dabra value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeDabra(out, value);
            }
        }

        public NonGrouped.Dabra read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return this.readDabra(in);
        }

        private void writeDabra(JsonWriter out, NonGrouped.Dabra instance) throws IOException {
            out.value((long)instance.dabra());
        }

        private NonGrouped.Dabra readDabra(JsonReader in) throws IOException {
            return ImmutableDabra.of(this.readParameterDabra(in));
        }

        private int readParameterDabra(JsonReader in) throws IOException {
            return in.nextInt();
        }
    }
}

