/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nested;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.nested.GroupedClasses;

@ParametersAreNonnullByDefault
final class ImmutableGroupedClasses {
    private ImmutableGroupedClasses() {
    }

    @Immutable
    static final class NestedOne
    implements GroupedClasses.NestedOne {
        private final Optional<GroupedClasses.Other> other;

        private NestedOne(Optional<GroupedClasses.Other> other) {
            this.other = other;
        }

        @Override
        public Optional<GroupedClasses.Other> other() {
            return this.other;
        }

        public final NestedOne withOther(GroupedClasses.Other value) {
            Optional newValue = Optional.of((Object)value);
            return new NestedOne((Optional<GroupedClasses.Other>)newValue);
        }

        public final NestedOne withOther(Optional<GroupedClasses.Other> optional) {
            Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"other");
            if (this.other == value) {
                return this;
            }
            return new NestedOne((Optional<GroupedClasses.Other>)value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof NestedOne && this.equalTo((NestedOne)another);
        }

        private boolean equalTo(NestedOne another) {
            return this.other.equals(another.other);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.other.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"NestedOne").add("other", this.other).toString();
        }

        public static NestedOne copyOf(GroupedClasses.NestedOne instance) {
            if (instance instanceof NestedOne) {
                return (NestedOne)instance;
            }
            return NestedOne.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        static final class Builder {
            private Optional<GroupedClasses.Other> other = Optional.absent();

            private Builder() {
            }

            public final Builder from(GroupedClasses.NestedOne instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                Optional<GroupedClasses.Other> otherOptional = instance.other();
                if (otherOptional.isPresent()) {
                    this.other(otherOptional);
                }
                return this;
            }

            public final Builder other(GroupedClasses.Other other) {
                this.other = Optional.of((Object)other);
                return this;
            }

            public final Builder other(Optional<GroupedClasses.Other> other) {
                this.other = (Optional)Preconditions.checkNotNull(other, (Object)"other");
                return this;
            }

            public NestedOne build() throws IllegalStateException {
                return new NestedOne(this.other);
            }
        }
    }
}

