/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nested;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.nested.AbstractSub;
import org.immutables.fixture.nested.BaseFrom;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableSub
implements AbstractSub {
    private final String c;
    private final String b;
    private final boolean isA;

    private ImmutableSub(String c, String b, boolean isA) {
        this.c = c;
        this.b = b;
        this.isA = isA;
    }

    @Override
    public String getC() {
        return this.c;
    }

    @Override
    public String getB() {
        return this.b;
    }

    @Override
    public boolean isA() {
        return this.isA;
    }

    public final ImmutableSub withC(String value) {
        if (this.c.equals(value)) {
            return this;
        }
        return new ImmutableSub((String)Preconditions.checkNotNull((Object)value, (Object)"c"), this.b, this.isA);
    }

    public final ImmutableSub withB(String value) {
        if (this.b.equals(value)) {
            return this;
        }
        return new ImmutableSub(this.c, (String)Preconditions.checkNotNull((Object)value, (Object)"b"), this.isA);
    }

    public final ImmutableSub withIsA(boolean value) {
        if (this.isA == value) {
            return this;
        }
        return new ImmutableSub(this.c, this.b, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSub && this.equalTo((ImmutableSub)another);
    }

    private boolean equalTo(ImmutableSub another) {
        return this.c.equals(another.c) && this.b.equals(another.b) && this.isA == another.isA;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.c.hashCode();
        h = h * 17 + this.b.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.isA);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Sub").add("c", (Object)this.c).add("b", (Object)this.b).add("isA", this.isA).toString();
    }

    public static ImmutableSub copyOf(AbstractSub instance) {
        if (instance instanceof ImmutableSub) {
            return (ImmutableSub)instance;
        }
        return ImmutableSub.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_C = 1L;
        private static final long INIT_BIT_B = 2L;
        private static final long INIT_BIT_IS_A = 4L;
        private long initBits = 7L;
        @Nullable
        private String c;
        @Nullable
        private String b;
        private boolean isA;

        private Builder() {
        }

        public final Builder from(BaseFrom instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractSub instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BaseFrom instance;
            if (object instanceof BaseFrom) {
                instance = (BaseFrom)object;
                this.b(instance.getB());
                this.isA(instance.isA());
            }
            if (object instanceof AbstractSub) {
                instance = (AbstractSub)object;
                this.c(instance.getC());
            }
        }

        public final Builder c(String c) {
            this.c = (String)Preconditions.checkNotNull((Object)c, (Object)"c");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder b(String b) {
            this.b = (String)Preconditions.checkNotNull((Object)b, (Object)"b");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder isA(boolean isA) {
            this.isA = isA;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableSub build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSub(this.c, this.b, this.isA);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("c");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("b");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("isA");
            }
            return "Cannot build Sub, some of required attributes are not set " + attributes;
        }
    }
}

