/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.strict;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.strict.Aar;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableAar
implements Aar {
    private final boolean bl;
    private final Integer integer;

    private ImmutableAar(boolean bl, Integer integer) {
        this.bl = bl;
        this.integer = integer;
    }

    @Override
    public boolean bl() {
        return this.bl;
    }

    @Override
    public Integer integer() {
        return this.integer;
    }

    public final ImmutableAar withBl(boolean value) {
        if (this.bl == value) {
            return this;
        }
        return new ImmutableAar(value, this.integer);
    }

    public final ImmutableAar withInteger(Integer value) {
        if (this.integer.equals(value)) {
            return this;
        }
        return new ImmutableAar(this.bl, (Integer)Preconditions.checkNotNull((Object)value, (Object)"integer"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAar && this.equalTo((ImmutableAar)another);
    }

    private boolean equalTo(ImmutableAar another) {
        return this.bl == another.bl && this.integer.equals(another.integer);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode((boolean)this.bl);
        h = h * 17 + this.integer.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Aar").add("bl", this.bl).add("integer", (Object)this.integer).toString();
    }

    public static ImmutableAar copyOf(Aar instance) {
        if (instance instanceof ImmutableAar) {
            return (ImmutableAar)instance;
        }
        return ImmutableAar.builder().bl(instance.bl()).integer(instance.integer()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_BL = 1L;
        private static final long INIT_BIT_INTEGER = 2L;
        private long initBits = 3L;
        private boolean bl;
        @Nullable
        private Integer integer;

        private Builder() {
        }

        public final Builder bl(boolean bl) {
            this.checkNotIsSet(this.blIsSet(), "bl");
            this.bl = bl;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder integer(Integer integer) {
            this.checkNotIsSet(this.integerIsSet(), "integer");
            this.integer = (Integer)Preconditions.checkNotNull((Object)integer, (Object)"integer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAar build() throws IllegalStateException {
            this.checkRequiredAttributes();
            return new ImmutableAar(this.bl, this.integer);
        }

        private boolean blIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean integerIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Aar is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (!this.blIsSet()) {
                attributes.add("bl");
            }
            if (!this.integerIsSet()) {
                attributes.add("integer");
            }
            return "Cannot build Aar, some of required attributes are not set " + attributes;
        }
    }
}

