/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.strict;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.strict.Bar;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableBar
implements Bar {
    private final ImmutableList<Integer> nums;
    private final ImmutableMap<String, Integer> mps;
    private final Optional<Integer> opt;

    private ImmutableBar(ImmutableList<Integer> nums, ImmutableMap<String, Integer> mps, Optional<Integer> opt) {
        this.nums = nums;
        this.mps = mps;
        this.opt = opt;
    }

    public ImmutableList<Integer> nums() {
        return this.nums;
    }

    public ImmutableMap<String, Integer> mps() {
        return this.mps;
    }

    @Override
    public Optional<Integer> opt() {
        return this.opt;
    }

    public final ImmutableBar withNums(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableBar((ImmutableList<Integer>)newValue, this.mps, this.opt);
    }

    public final ImmutableBar withNums(Iterable<Integer> elements) {
        if (this.nums == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBar((ImmutableList<Integer>)newValue, this.mps, this.opt);
    }

    public final ImmutableBar withMps(Map<String, ? extends Integer> entries) {
        if (this.mps == entries) {
            return this;
        }
        ImmutableMap value = ImmutableMap.copyOf(entries);
        return new ImmutableBar(this.nums, (ImmutableMap<String, Integer>)value, this.opt);
    }

    public final ImmutableBar withOpt(int value) {
        Optional newValue = Optional.of((Object)value);
        return new ImmutableBar(this.nums, this.mps, (Optional<Integer>)newValue);
    }

    public final ImmutableBar withOpt(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"opt");
        if (this.opt == value) {
            return this;
        }
        return new ImmutableBar(this.nums, this.mps, (Optional<Integer>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBar && this.equalTo((ImmutableBar)another);
    }

    private boolean equalTo(ImmutableBar another) {
        return this.nums.equals(another.nums) && this.mps.equals(another.mps) && this.opt.equals(another.opt);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.nums.hashCode();
        h = h * 17 + this.mps.hashCode();
        h = h * 17 + this.opt.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Bar").add("nums", this.nums).add("mps", this.mps).add("opt", this.opt).toString();
    }

    public static ImmutableBar copyOf(Bar instance) {
        if (instance instanceof ImmutableBar) {
            return (ImmutableBar)instance;
        }
        return ImmutableBar.builder().addAllNums(instance.nums()).putAllMps(instance.mps()).opt(instance.opt()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long OPT_BIT_OPT = 1L;
        private long optBits;
        private ImmutableList.Builder<Integer> numsBuilder = ImmutableList.builder();
        private ImmutableMap.Builder<String, Integer> mpsBuilder = ImmutableMap.builder();
        private Optional<Integer> opt = Optional.absent();

        private Builder() {
        }

        public final Builder addNums(int element) {
            this.numsBuilder.add((Object)element);
            return this;
        }

        public final Builder addNums(int ... elements) {
            this.numsBuilder.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        public final Builder addAllNums(Iterable<Integer> elements) {
            this.numsBuilder.addAll(elements);
            return this;
        }

        public final Builder putMps(String key, int value) {
            this.mpsBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putMps(Map.Entry<String, ? extends Integer> entry) {
            this.mpsBuilder.put(entry);
            return this;
        }

        public final Builder putAllMps(Map<String, ? extends Integer> entries) {
            this.mpsBuilder.putAll(entries);
            return this;
        }

        public final Builder opt(int opt) {
            this.checkNotIsSet(this.optIsSet(), "opt");
            this.opt = Optional.of((Object)opt);
            this.optBits |= 1L;
            return this;
        }

        public final Builder opt(Optional<Integer> opt) {
            this.checkNotIsSet(this.optIsSet(), "opt");
            this.opt = (Optional)Preconditions.checkNotNull(opt, (Object)"opt");
            this.optBits |= 1L;
            return this;
        }

        public ImmutableBar build() throws IllegalStateException {
            return new ImmutableBar(this.numsBuilder.build(), this.mpsBuilder.build(), this.opt);
        }

        private boolean optIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Bar is strict, attribute is already set: ".concat(name));
            }
        }
    }
}

