/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.AInterface;

@ParametersAreNonnullByDefault
@NotThreadSafe
final class AInterfaceBuilder {
    private static final long INIT_BIT_STRING = 1L;
    private long initBits = 1L;
    @Nullable
    private String string;

    AInterfaceBuilder() {
    }

    public final AInterfaceBuilder from(AInterface instance) {
        Preconditions.checkNotNull((Object)instance, (Object)"instance");
        this.string(instance.getString());
        return this;
    }

    public final AInterfaceBuilder string(String string) {
        this.string = (String)Preconditions.checkNotNull((Object)string, (Object)"string");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public ImmutableAInterface build() throws IllegalStateException {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableAInterface(this.string);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList attributes = Lists.newArrayList();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("string");
        }
        return "Cannot build AInterface, some of required attributes are not set " + attributes;
    }

    @Immutable
    public static final class ImmutableAInterface
    implements AInterface {
        private final String string;

        private ImmutableAInterface(String string) {
            this.string = string;
        }

        @Override
        public String getString() {
            return this.string;
        }

        public final ImmutableAInterface withString(String value) {
            if (this.string.equals(value)) {
                return this;
            }
            return new ImmutableAInterface((String)Preconditions.checkNotNull((Object)value, (Object)"string"));
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableAInterface && this.equalTo((ImmutableAInterface)another);
        }

        private boolean equalTo(ImmutableAInterface another) {
            return this.string.equals(another.string);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.string.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"AInterface").add("string", (Object)this.string).toString();
        }

        public static ImmutableAInterface copyOf(AInterface instance) {
            if (instance instanceof ImmutableAInterface) {
                return (ImmutableAInterface)instance;
            }
            return new AInterfaceBuilder().from(instance).build();
        }
    }
}

