/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.fixture.style.Color;

@ParametersAreNonnullByDefault
@Immutable
final class ColorTuple
implements Color {
    private final int red;
    private final int green;
    private final int blue;

    private ColorTuple(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    @Override
    public int red() {
        return this.red;
    }

    @Override
    public int green() {
        return this.green;
    }

    @Override
    public int blue() {
        return this.blue;
    }

    public final ColorTuple withRed(int value) {
        if (this.red == value) {
            return this;
        }
        return new ColorTuple(value, this.green, this.blue);
    }

    public final ColorTuple withGreen(int value) {
        if (this.green == value) {
            return this;
        }
        return new ColorTuple(this.red, value, this.blue);
    }

    public final ColorTuple withBlue(int value) {
        if (this.blue == value) {
            return this;
        }
        return new ColorTuple(this.red, this.green, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ColorTuple && this.equalTo((ColorTuple)another);
    }

    private boolean equalTo(ColorTuple another) {
        return this.red == another.red && this.green == another.green && this.blue == another.blue;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.red;
        h = h * 17 + this.green;
        h = h * 17 + this.blue;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Color").add("red", this.red).add("green", this.green).add("blue", this.blue).toString();
    }

    public static ColorTuple of(int red, int green, int blue) {
        return new ColorTuple(red, green, blue);
    }

    public static ColorTuple copyOf(Color instance) {
        if (instance instanceof ColorTuple) {
            return (ColorTuple)instance;
        }
        return ColorTuple.of(instance.red(), instance.green(), instance.blue());
    }
}

