/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.ConservativeStyleDetected;

@ParametersAreNonnullByDefault
@NotThreadSafe
public final class ConservativeStyleDetectedBuilder {
    private static final long INIT_BIT_VALUE = 1L;
    private static final long INIT_BIT_STRING = 2L;
    private long initBits = 3L;
    private ImmutableList.Builder<String> emBuilder = ImmutableList.builder();
    private int value;
    @Nullable
    private String string;

    public final ConservativeStyleDetectedBuilder from(ConservativeStyleDetected instance) {
        Preconditions.checkNotNull((Object)instance, (Object)"instance");
        this.addAllEm(instance.getEm());
        this.setValue(instance.getValue());
        this.setString(instance.getString());
        return this;
    }

    public final ConservativeStyleDetectedBuilder addEm(String element) {
        this.emBuilder.add((Object)element);
        return this;
    }

    public final ConservativeStyleDetectedBuilder addEm(String ... elements) {
        this.emBuilder.add((Object[])elements);
        return this;
    }

    public final ConservativeStyleDetectedBuilder setEm(Iterable<String> elements) {
        this.emBuilder = ImmutableList.builder();
        return this.addAllEm(elements);
    }

    public final ConservativeStyleDetectedBuilder addAllEm(Iterable<String> elements) {
        this.emBuilder.addAll(elements);
        return this;
    }

    public final ConservativeStyleDetectedBuilder setValue(int value) {
        this.value = value;
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final ConservativeStyleDetectedBuilder setString(String string) {
        this.string = (String)Preconditions.checkNotNull((Object)string, (Object)"string");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public ConservativeStyleDetected build() throws IllegalStateException {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableConservativeStyleDetected(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList attributes = Lists.newArrayList();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("value");
        }
        if ((this.initBits & 2L) != 0L) {
            attributes.add("string");
        }
        return "Cannot build ConservativeStyleDetected, some of required attributes are not set " + attributes;
    }

    @Immutable
    private static final class ImmutableConservativeStyleDetected
    extends ConservativeStyleDetected {
        private final ImmutableList<String> em;
        private final int value;
        private final String string;

        private ImmutableConservativeStyleDetected(ConservativeStyleDetectedBuilder builder) {
            this.em = builder.emBuilder.build();
            this.value = builder.value;
            this.string = builder.string;
        }

        ImmutableList<String> getEm() {
            return this.em;
        }

        @Override
        int getValue() {
            return this.value;
        }

        @Override
        String getString() {
            return this.string;
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableConservativeStyleDetected && this.equalTo((ImmutableConservativeStyleDetected)another);
        }

        private boolean equalTo(ImmutableConservativeStyleDetected another) {
            return this.em.equals(another.em) && this.value == another.value && this.string.equals(another.string);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.em.hashCode();
            h = h * 17 + this.value;
            h = h * 17 + this.string.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ConservativeStyleDetected").add("em", this.em).add("value", this.value).add("string", (Object)this.string).toString();
        }
    }
}

