/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.EnclosingHiddenImplementation;

@ParametersAreNonnullByDefault
final class EnclosingFactory {
    private EnclosingFactory() {
    }

    public static EnclosingHiddenImplementation.VisibleImplementation newVisibleImplementation(Optional<Integer> cons) {
        return VisibleImplementation.newVisibleImplementation(cons);
    }

    public static EnclosingHiddenImplementation.NonexposedImplementation singletonInstanceNonexposedImplementation() {
        return NonexposedImplementation.singletonInstance();
    }

    public static EnclosingHiddenImplementation.NonexposedImplementation newNonexposedImplementation(Optional<Integer> cons) {
        return NonexposedImplementation.newNonexposedImplementation(cons);
    }

    public static EnclosingHiddenImplementation.HiddenImplementation singletonInstanceHiddenImplementation() {
        return HiddenImplementation.singletonInstance();
    }

    @NotThreadSafe
    public static final class HiddenImplementationBuilder {
        private HiddenImplementationBuilder() {
        }

        public static HiddenImplementationBuilder create() {
            return new HiddenImplementationBuilder();
        }

        public final HiddenImplementationBuilder from(EnclosingHiddenImplementation.HiddenImplementation instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            return this;
        }

        public EnclosingHiddenImplementation.HiddenImplementation build() throws IllegalStateException {
            return EnclosingFactory.singletonInstanceHiddenImplementation();
        }
    }

    @Immutable
    private static final class HiddenImplementation
    extends EnclosingHiddenImplementation.HiddenImplementation {
        private static final HiddenImplementation INSTANCE = HiddenImplementation.validate(new HiddenImplementation());

        private HiddenImplementation() {
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof HiddenImplementation && this.equalTo((HiddenImplementation)another);
        }

        private boolean equalTo(HiddenImplementation another) {
            return true;
        }

        public int hashCode() {
            return 848011062;
        }

        public String toString() {
            return "HiddenImplementation{}";
        }

        public static EnclosingHiddenImplementation.HiddenImplementation singletonInstance() {
            return INSTANCE;
        }

        private static HiddenImplementation validate(HiddenImplementation instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }
    }

    @NotThreadSafe
    public static final class NonexposedImplementationBuilder {
        private Optional<Integer> cons = Optional.absent();

        private NonexposedImplementationBuilder() {
        }

        public static NonexposedImplementationBuilder create() {
            return new NonexposedImplementationBuilder();
        }

        public final NonexposedImplementationBuilder from(EnclosingHiddenImplementation.NonexposedImplementation instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<Integer> consOptional = instance.cons();
            if (consOptional.isPresent()) {
                this.cons(consOptional);
            }
            return this;
        }

        public final NonexposedImplementationBuilder cons(int cons) {
            this.cons = Optional.of((Object)cons);
            return this;
        }

        public final NonexposedImplementationBuilder cons(Optional<Integer> cons) {
            this.cons = (Optional)Preconditions.checkNotNull(cons, (Object)"cons");
            return this;
        }

        public EnclosingHiddenImplementation.NonexposedImplementation build() throws IllegalStateException {
            return NonexposedImplementation.validate(new NonexposedImplementation(this));
        }
    }

    @Immutable
    private static final class NonexposedImplementation
    extends EnclosingHiddenImplementation.NonexposedImplementation {
        private final Optional<Integer> cons;
        private static final NonexposedImplementation INSTANCE = NonexposedImplementation.validate(new NonexposedImplementation());

        private NonexposedImplementation() {
            this.cons = Optional.absent();
        }

        private NonexposedImplementation(Optional<Integer> cons) {
            this.cons = (Optional)Preconditions.checkNotNull(cons, (Object)"cons");
        }

        private NonexposedImplementation(NonexposedImplementationBuilder builder) {
            this.cons = builder.cons;
        }

        @Override
        public Optional<Integer> cons() {
            return this.cons;
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof NonexposedImplementation && this.equalTo((NonexposedImplementation)another);
        }

        private boolean equalTo(NonexposedImplementation another) {
            return this.cons.equals(another.cons);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.cons.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"NonexposedImplementation").add("cons", this.cons).toString();
        }

        public static EnclosingHiddenImplementation.NonexposedImplementation singletonInstance() {
            return INSTANCE;
        }

        public static EnclosingHiddenImplementation.NonexposedImplementation newNonexposedImplementation(Optional<Integer> cons) {
            return NonexposedImplementation.validate(new NonexposedImplementation(cons));
        }

        private static NonexposedImplementation validate(NonexposedImplementation instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }
    }

    @Immutable
    private static final class VisibleImplementation
    extends EnclosingHiddenImplementation.VisibleImplementation {
        private final Optional<Integer> cons;

        private VisibleImplementation(Optional<Integer> cons) {
            this.cons = (Optional)Preconditions.checkNotNull(cons, (Object)"cons");
        }

        @Override
        public Optional<Integer> cons() {
            return this.cons;
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof VisibleImplementation && this.equalTo((VisibleImplementation)another);
        }

        private boolean equalTo(VisibleImplementation another) {
            return this.cons.equals(another.cons);
        }

        public int hashCode() {
            int h = 31;
            h = h * 17 + this.cons.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"VisibleImplementation").add("cons", this.cons).toString();
        }

        public static EnclosingHiddenImplementation.VisibleImplementation newVisibleImplementation(Optional<Integer> cons) {
            return new VisibleImplementation(cons);
        }
    }
}

