/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.Constr;

@ParametersAreNonnullByDefault
@Immutable
public final class ImBuild
implements Constr.Build {
    private final String date;
    private final String qualifier;

    public ImBuild(String date, String qualifier) {
        this.date = (String)Preconditions.checkNotNull((Object)date, (Object)"date");
        this.qualifier = (String)Preconditions.checkNotNull((Object)qualifier, (Object)"qualifier");
    }

    private ImBuild(ImBuild original, String date, String qualifier) {
        this.date = date;
        this.qualifier = qualifier;
    }

    @Override
    public String date() {
        return this.date;
    }

    @Override
    public String qualifier() {
        return this.qualifier;
    }

    public final ImBuild withDate(String value) {
        if (this.date.equals(value)) {
            return this;
        }
        return new ImBuild(this, (String)Preconditions.checkNotNull((Object)value, (Object)"date"), this.qualifier);
    }

    public final ImBuild withQualifier(String value) {
        if (this.qualifier.equals(value)) {
            return this;
        }
        return new ImBuild(this, this.date, (String)Preconditions.checkNotNull((Object)value, (Object)"qualifier"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImBuild && this.equalTo((ImBuild)another);
    }

    private boolean equalTo(ImBuild another) {
        return this.date.equals(another.date) && this.qualifier.equals(another.qualifier);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.date.hashCode();
        h = h * 17 + this.qualifier.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Build").add("date", (Object)this.date).add("qualifier", (Object)this.qualifier).toString();
    }

    public static ImBuild copyOf(Constr.Build instance) {
        if (instance instanceof ImBuild) {
            return (ImBuild)instance;
        }
        return ImBuild.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATE = 1L;
        private static final long INIT_BIT_QUALIFIER = 2L;
        private long initBits = 3L;
        @Nullable
        private String date;
        @Nullable
        private String qualifier;

        private Builder() {
        }

        public final Builder from(Constr.Build instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.date(instance.date());
            this.qualifier(instance.qualifier());
            return this;
        }

        public final Builder date(String date) {
            this.date = (String)Preconditions.checkNotNull((Object)date, (Object)"date");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder qualifier(String qualifier) {
            this.qualifier = (String)Preconditions.checkNotNull((Object)qualifier, (Object)"qualifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImBuild build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImBuild(null, this.date, this.qualifier);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("qualifier");
            }
            return "Cannot build Build, some of required attributes are not set " + attributes;
        }
    }
}

