/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.Constr;

@ParametersAreNonnullByDefault
@Immutable
public final class ImRev
implements Constr.Rev {
    private final int major;
    private final int minor;

    public ImRev(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    @Override
    public int major() {
        return this.major;
    }

    @Override
    public int minor() {
        return this.minor;
    }

    public final ImRev withMajor(int value) {
        if (this.major == value) {
            return this;
        }
        return new ImRev(value, this.minor);
    }

    public final ImRev withMinor(int value) {
        if (this.minor == value) {
            return this;
        }
        return new ImRev(this.major, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImRev && this.equalTo((ImRev)another);
    }

    private boolean equalTo(ImRev another) {
        return this.major == another.major && this.minor == another.minor;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.major;
        h = h * 17 + this.minor;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Rev").add("major", this.major).add("minor", this.minor).toString();
    }

    public static ImRev copyOf(Constr.Rev instance) {
        if (instance instanceof ImRev) {
            return (ImRev)instance;
        }
        return ImRev.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MAJOR = 1L;
        private static final long INIT_BIT_MINOR = 2L;
        private long initBits = 3L;
        private int major;
        private int minor;

        private Builder() {
        }

        public final Builder from(Constr.Rev instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.major(instance.major());
            this.minor(instance.minor());
            return this;
        }

        public final Builder major(int major) {
            this.major = major;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder minor(int minor) {
            this.minor = minor;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImRev build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImRev(this.major, this.minor);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("major");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("minor");
            }
            return "Cannot build Rev, some of required attributes are not set " + attributes;
        }
    }
}

