/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.BeanStyleDetected;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableBeanStyleDetected
extends BeanStyleDetected {
    private final int it;
    private final ImmutableList<String> em;

    private ImmutableBeanStyleDetected(int it, ImmutableList<String> em) {
        this.it = it;
        this.em = em;
    }

    @Override
    int isIt() {
        return this.it;
    }

    ImmutableList<String> getEm() {
        return this.em;
    }

    public final ImmutableBeanStyleDetected withIt(int value) {
        if (this.it == value) {
            return this;
        }
        return new ImmutableBeanStyleDetected(value, this.em);
    }

    public final ImmutableBeanStyleDetected withEm(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableBeanStyleDetected(this.it, (ImmutableList<String>)newValue);
    }

    public final ImmutableBeanStyleDetected withEm(Iterable<String> elements) {
        if (this.em == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBeanStyleDetected(this.it, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBeanStyleDetected && this.equalTo((ImmutableBeanStyleDetected)another);
    }

    private boolean equalTo(ImmutableBeanStyleDetected another) {
        return this.it == another.it && this.em.equals(another.em);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.it;
        h = h * 17 + this.em.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BeanStyleDetected").add("it", this.it).add("em", this.em).toString();
    }

    public static ImmutableBeanStyleDetected copyOf(BeanStyleDetected instance) {
        if (instance instanceof ImmutableBeanStyleDetected) {
            return (ImmutableBeanStyleDetected)instance;
        }
        return ImmutableBeanStyleDetected.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_IT = 1L;
        private long initBits = 1L;
        private int it;
        private ImmutableList.Builder<String> emBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(BeanStyleDetected instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.setIt(instance.isIt());
            this.addAllEm(instance.getEm());
            return this;
        }

        public final Builder setIt(int it) {
            this.it = it;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addEm(String element) {
            this.emBuilder.add((Object)element);
            return this;
        }

        public final Builder addEm(String ... elements) {
            this.emBuilder.add((Object[])elements);
            return this;
        }

        public final Builder setEm(Iterable<String> elements) {
            this.emBuilder = ImmutableList.builder();
            return this.addAllEm(elements);
        }

        public final Builder addAllEm(Iterable<String> elements) {
            this.emBuilder.addAll(elements);
            return this;
        }

        public ImmutableBeanStyleDetected build() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBeanStyleDetected(this.it, this.emBuilder.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("it");
            }
            return "Cannot build BeanStyleDetected, some of required attributes are not set " + attributes;
        }
    }
}

