/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.Depluralize;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableDepluralize
implements Depluralize {
    private final ImmutableList<String> feet;
    private final ImmutableSet<String> boats;
    private final ImmutableMap<String, String> people;
    private final ImmutableMultimap<String, String> peopleRepublics;
    private final ImmutableList<Integer> feetPeople;
    private final ImmutableMultiset<Boolean> goods;

    private ImmutableDepluralize(ImmutableList<String> feet, ImmutableSet<String> boats, ImmutableMap<String, String> people, ImmutableMultimap<String, String> peopleRepublics, ImmutableList<Integer> feetPeople, ImmutableMultiset<Boolean> goods) {
        this.feet = feet;
        this.boats = boats;
        this.people = people;
        this.peopleRepublics = peopleRepublics;
        this.feetPeople = feetPeople;
        this.goods = goods;
    }

    public ImmutableList<String> feet() {
        return this.feet;
    }

    public ImmutableSet<String> boats() {
        return this.boats;
    }

    public ImmutableMap<String, String> people() {
        return this.people;
    }

    public ImmutableMultimap<String, String> peopleRepublics() {
        return this.peopleRepublics;
    }

    public ImmutableList<Integer> feetPeople() {
        return this.feetPeople;
    }

    public ImmutableMultiset<Boolean> goods() {
        return this.goods;
    }

    public final ImmutableDepluralize withFeet(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDepluralize((ImmutableList<String>)newValue, this.boats, this.people, this.peopleRepublics, this.feetPeople, this.goods);
    }

    public final ImmutableDepluralize withFeet(Iterable<String> elements) {
        if (this.feet == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDepluralize((ImmutableList<String>)newValue, this.boats, this.people, this.peopleRepublics, this.feetPeople, this.goods);
    }

    public final ImmutableDepluralize withBoats(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableDepluralize(this.feet, (ImmutableSet<String>)newValue, this.people, this.peopleRepublics, this.feetPeople, this.goods);
    }

    public final ImmutableDepluralize withBoats(Iterable<String> elements) {
        if (this.boats == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableDepluralize(this.feet, (ImmutableSet<String>)newValue, this.people, this.peopleRepublics, this.feetPeople, this.goods);
    }

    public final ImmutableDepluralize withPeople(Map<String, ? extends String> entries) {
        if (this.people == entries) {
            return this;
        }
        ImmutableMap value = ImmutableMap.copyOf(entries);
        return new ImmutableDepluralize(this.feet, this.boats, (ImmutableMap<String, String>)value, this.peopleRepublics, this.feetPeople, this.goods);
    }

    public final ImmutableDepluralize withPeopleRepublics(Multimap<String, ? extends String> entries) {
        if (this.peopleRepublics == entries) {
            return this;
        }
        ImmutableMultimap value = ImmutableMultimap.copyOf(entries);
        return new ImmutableDepluralize(this.feet, this.boats, this.people, (ImmutableMultimap<String, String>)value, this.feetPeople, this.goods);
    }

    public final ImmutableDepluralize withFeetPeople(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableDepluralize(this.feet, this.boats, this.people, this.peopleRepublics, (ImmutableList<Integer>)newValue, this.goods);
    }

    public final ImmutableDepluralize withFeetPeople(Iterable<Integer> elements) {
        if (this.feetPeople == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDepluralize(this.feet, this.boats, this.people, this.peopleRepublics, (ImmutableList<Integer>)newValue, this.goods);
    }

    public final ImmutableDepluralize withGoods(boolean ... elements) {
        ImmutableMultiset newValue = ImmutableMultiset.copyOf((Iterable)Booleans.asList((boolean[])elements));
        return new ImmutableDepluralize(this.feet, this.boats, this.people, this.peopleRepublics, this.feetPeople, (ImmutableMultiset<Boolean>)newValue);
    }

    public final ImmutableDepluralize withGoods(Iterable<Boolean> elements) {
        if (this.goods == elements) {
            return this;
        }
        ImmutableMultiset newValue = ImmutableMultiset.copyOf(elements);
        return new ImmutableDepluralize(this.feet, this.boats, this.people, this.peopleRepublics, this.feetPeople, (ImmutableMultiset<Boolean>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDepluralize && this.equalTo((ImmutableDepluralize)another);
    }

    private boolean equalTo(ImmutableDepluralize another) {
        return this.feet.equals(another.feet) && this.boats.equals(another.boats) && this.people.equals(another.people) && this.peopleRepublics.equals(another.peopleRepublics) && this.feetPeople.equals(another.feetPeople) && this.goods.equals(another.goods);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.feet.hashCode();
        h = h * 17 + this.boats.hashCode();
        h = h * 17 + this.people.hashCode();
        h = h * 17 + this.peopleRepublics.hashCode();
        h = h * 17 + this.feetPeople.hashCode();
        h = h * 17 + this.goods.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Depluralize").add("feet", this.feet).add("boats", this.boats).add("people", this.people).add("peopleRepublics", this.peopleRepublics).add("feetPeople", this.feetPeople).add("goods", this.goods).toString();
    }

    public static ImmutableDepluralize copyOf(Depluralize instance) {
        if (instance instanceof ImmutableDepluralize) {
            return (ImmutableDepluralize)instance;
        }
        return ImmutableDepluralize.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<String> feetBuilder = ImmutableList.builder();
        private ImmutableSet.Builder<String> boatsBuilder = ImmutableSet.builder();
        private ImmutableMap.Builder<String, String> peopleBuilder = ImmutableMap.builder();
        private ImmutableMultimap.Builder<String, String> peopleRepublicsBuilder = ImmutableMultimap.builder();
        private ImmutableList.Builder<Integer> feetPeopleBuilder = ImmutableList.builder();
        private ImmutableMultiset.Builder<Boolean> goodsBuilder = ImmutableMultiset.builder();

        private Builder() {
        }

        public final Builder from(Depluralize instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllFeet(instance.feet());
            this.addAllBoats(instance.boats());
            this.putAllPeople(instance.people());
            this.putAllPeopleRepublics(instance.peopleRepublics());
            this.addAllFeetPeople(instance.feetPeople());
            this.addAllGoods((Iterable<Boolean>)instance.goods());
            return this;
        }

        public final Builder addFoot(String element) {
            this.feetBuilder.add((Object)element);
            return this;
        }

        public final Builder addFoot(String ... elements) {
            this.feetBuilder.add((Object[])elements);
            return this;
        }

        public final Builder feet(Iterable<String> elements) {
            this.feetBuilder = ImmutableList.builder();
            return this.addAllFeet(elements);
        }

        public final Builder addAllFeet(Iterable<String> elements) {
            this.feetBuilder.addAll(elements);
            return this;
        }

        public final Builder addBoat(String element) {
            this.boatsBuilder.add((Object)element);
            return this;
        }

        public final Builder addBoat(String ... elements) {
            this.boatsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder boats(Iterable<String> elements) {
            this.boatsBuilder = ImmutableSet.builder();
            return this.addAllBoats(elements);
        }

        public final Builder addAllBoats(Iterable<String> elements) {
            this.boatsBuilder.addAll(elements);
            return this;
        }

        public final Builder putPerson(String key, String value) {
            this.peopleBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putPerson(Map.Entry<String, ? extends String> entry) {
            this.peopleBuilder.put(entry);
            return this;
        }

        public final Builder people(Map<String, ? extends String> entries) {
            this.peopleBuilder = ImmutableMap.builder();
            return this.putAllPeople(entries);
        }

        public final Builder putAllPeople(Map<String, ? extends String> entries) {
            this.peopleBuilder.putAll(entries);
            return this;
        }

        public final Builder putPeopleRepublic(String key, String ... values) {
            this.peopleRepublicsBuilder.putAll((Object)key, Arrays.asList(values));
            return this;
        }

        public final Builder putAllPeopleRepublics(String key, Iterable<String> values) {
            this.peopleRepublicsBuilder.putAll((Object)key, values);
            return this;
        }

        public final Builder putPeopleRepublic(String key, String value) {
            this.peopleRepublicsBuilder.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putPeopleRepublic(Map.Entry<String, ? extends String> entry) {
            this.peopleRepublicsBuilder.put(entry);
            return this;
        }

        public final Builder peopleRepublics(Multimap<String, ? extends String> entries) {
            this.peopleRepublicsBuilder = ImmutableMultimap.builder();
            return this.putAllPeopleRepublics(entries);
        }

        public final Builder putAllPeopleRepublics(Multimap<String, ? extends String> entries) {
            this.peopleRepublicsBuilder.putAll(entries);
            return this;
        }

        public final Builder addFeetPerson(int element) {
            this.feetPeopleBuilder.add((Object)element);
            return this;
        }

        public final Builder addFeetPerson(int ... elements) {
            this.feetPeopleBuilder.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        public final Builder feetPeople(Iterable<Integer> elements) {
            this.feetPeopleBuilder = ImmutableList.builder();
            return this.addAllFeetPeople(elements);
        }

        public final Builder addAllFeetPeople(Iterable<Integer> elements) {
            this.feetPeopleBuilder.addAll(elements);
            return this;
        }

        public final Builder addGoods(boolean element) {
            this.goodsBuilder.add((Object)element);
            return this;
        }

        public final Builder addGoods(boolean ... elements) {
            this.goodsBuilder.addAll((Iterable)Booleans.asList((boolean[])elements));
            return this;
        }

        public final Builder goods(Iterable<Boolean> elements) {
            this.goodsBuilder = ImmutableMultiset.builder();
            return this.addAllGoods(elements);
        }

        public final Builder addAllGoods(Iterable<Boolean> elements) {
            this.goodsBuilder.addAll(elements);
            return this;
        }

        public ImmutableDepluralize build() throws IllegalStateException {
            return new ImmutableDepluralize(this.feetBuilder.build(), this.boatsBuilder.build(), this.peopleBuilder.build(), this.peopleRepublicsBuilder.build(), this.feetPeopleBuilder.build(), this.goodsBuilder.build());
        }
    }
}

