/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
public final class ImmutableIncludeNestedTypes {
    private ImmutableIncludeNestedTypes() {
    }

    @Immutable
    public static final class Retention
    implements java.lang.annotation.Retention {
        private final RetentionPolicy value;

        private Retention(RetentionPolicy value) {
            this.value = (RetentionPolicy)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"value"));
        }

        private Retention(Retention original, RetentionPolicy value) {
            this.value = value;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return java.lang.annotation.Retention.class;
        }

        @Override
        public RetentionPolicy value() {
            return this.value;
        }

        public final Retention copyWithValue(RetentionPolicy value) {
            if (this.value == value) {
                return this;
            }
            return new Retention(this, (RetentionPolicy)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"value")));
        }

        @Override
        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof java.lang.annotation.Retention && this.equalTo((java.lang.annotation.Retention)another);
        }

        private boolean equalTo(java.lang.annotation.Retention another) {
            return this.value.equals((Object)another.value());
        }

        @Override
        public int hashCode() {
            int h = 0;
            return h += 127 * "value".hashCode() ^ this.value.hashCode();
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((String)"@Retention").add("value", (Object)this.value).toString();
        }

        public static Retention of(RetentionPolicy value) {
            return new Retention(value);
        }

        public static Retention copyOf(java.lang.annotation.Retention instance) {
            if (instance instanceof Retention) {
                return (Retention)instance;
            }
            return Retention.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private long initBits = 1L;
            @Nullable
            private RetentionPolicy value;

            private Builder() {
            }

            public final Builder from(java.lang.annotation.Retention instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.value(instance.value());
                return this;
            }

            public final Builder value(RetentionPolicy value) {
                this.value = (RetentionPolicy)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"value"));
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Retention build() throws IllegalStateException {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Retention(null, this.value);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build Retention, some of required attributes are not set " + attributes;
            }
        }
    }

    @Immutable
    public static final class Target
    implements java.lang.annotation.Target {
        private final ElementType[] value;

        private Target(ElementType[] value) {
            this.value = (ElementType[])Preconditions.checkNotNull((Object)value, (Object)"value");
        }

        private Target(Target original, ElementType[] value) {
            this.value = value;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return java.lang.annotation.Target.class;
        }

        @Override
        public ElementType[] value() {
            return (ElementType[])this.value.clone();
        }

        public final Target copyWithValue(ElementType ... elements) {
            ElementType[] newValue = (ElementType[])elements.clone();
            return new Target(this, newValue);
        }

        @Override
        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof java.lang.annotation.Target && this.equalTo((java.lang.annotation.Target)another);
        }

        private boolean equalTo(java.lang.annotation.Target another) {
            return Arrays.equals((Object[])this.value, (Object[])another.value());
        }

        @Override
        public int hashCode() {
            int h = 0;
            return h += 127 * "value".hashCode() ^ Arrays.hashCode((Object[])this.value);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((String)"@Target").add("value", (Object)Arrays.toString((Object[])this.value)).toString();
        }

        public static Target of(ElementType[] value) {
            return new Target(value);
        }

        public static Target copyOf(java.lang.annotation.Target instance) {
            if (instance instanceof Target) {
                return (Target)instance;
            }
            return Target.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private long initBits = 1L;
            @Nullable
            private ElementType[] value;

            private Builder() {
            }

            public final Builder from(java.lang.annotation.Target instance) {
                Preconditions.checkNotNull((Object)instance, (Object)"instance");
                this.value(instance.value());
                return this;
            }

            public final Builder value(ElementType ... elements) {
                this.value = (ElementType[])elements.clone();
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Target build() throws IllegalStateException {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Target(null, this.value);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList attributes = Lists.newArrayList();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build Target, some of required attributes are not set " + attributes;
            }
        }
    }
}

