/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.OptionalWithNullable;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableOptionalWithNullable
implements OptionalWithNullable {
    @Nullable
    private final String javaOptional;
    @Nullable
    private final Integer javaOptionalInt;
    @Nullable
    private final Integer javaOptionalInteger;
    private final com.google.common.base.Optional<String> guavaOptional;

    private ImmutableOptionalWithNullable(@Nullable String javaOptional, @Nullable Integer javaOptionalInt, @Nullable Integer javaOptionalInteger, com.google.common.base.Optional<String> guavaOptional) {
        this.javaOptional = javaOptional;
        this.javaOptionalInt = javaOptionalInt;
        this.javaOptionalInteger = javaOptionalInteger;
        this.guavaOptional = guavaOptional;
    }

    @Override
    public Optional<String> getJavaOptional() {
        return Optional.ofNullable(this.javaOptional);
    }

    @Override
    public OptionalInt getJavaOptionalInt() {
        return this.javaOptionalInt != null ? OptionalInt.of(this.javaOptionalInt) : OptionalInt.empty();
    }

    @Override
    public Optional<Integer> getJavaOptionalInteger() {
        return Optional.ofNullable(this.javaOptionalInteger);
    }

    @Override
    public com.google.common.base.Optional<String> getGuavaOptional() {
        return this.guavaOptional;
    }

    public final ImmutableOptionalWithNullable withJavaOptional(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.javaOptional, newValue)) {
            return this;
        }
        return new ImmutableOptionalWithNullable(newValue, this.javaOptionalInt, this.javaOptionalInteger, this.guavaOptional);
    }

    public final ImmutableOptionalWithNullable withJavaOptional(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.javaOptional, value)) {
            return this;
        }
        return new ImmutableOptionalWithNullable(value, this.javaOptionalInt, this.javaOptionalInteger, this.guavaOptional);
    }

    public final ImmutableOptionalWithNullable withJavaOptionalInt(int value) {
        Integer newValue = value;
        if (this.javaOptionalInt == newValue) {
            return this;
        }
        return new ImmutableOptionalWithNullable(this.javaOptional, newValue, this.javaOptionalInteger, this.guavaOptional);
    }

    public final ImmutableOptionalWithNullable withJavaOptionalInt(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (this.javaOptionalInt == value) {
            return this;
        }
        return new ImmutableOptionalWithNullable(this.javaOptional, value, this.javaOptionalInteger, this.guavaOptional);
    }

    public final ImmutableOptionalWithNullable withJavaOptionalInteger(@Nullable Integer value) {
        Integer newValue = value;
        if (this.javaOptionalInteger == newValue) {
            return this;
        }
        return new ImmutableOptionalWithNullable(this.javaOptional, this.javaOptionalInt, newValue, this.guavaOptional);
    }

    public final ImmutableOptionalWithNullable withJavaOptionalInteger(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (this.javaOptionalInteger == value) {
            return this;
        }
        return new ImmutableOptionalWithNullable(this.javaOptional, this.javaOptionalInt, value, this.guavaOptional);
    }

    public final ImmutableOptionalWithNullable withGuavaOptional(@Nullable String value) {
        com.google.common.base.Optional newValue = com.google.common.base.Optional.fromNullable((Object)value);
        return new ImmutableOptionalWithNullable(this.javaOptional, this.javaOptionalInt, this.javaOptionalInteger, (com.google.common.base.Optional<String>)newValue);
    }

    public final ImmutableOptionalWithNullable withGuavaOptional(com.google.common.base.Optional<String> optional) {
        com.google.common.base.Optional value = (com.google.common.base.Optional)Preconditions.checkNotNull(optional, (Object)"guavaOptional");
        if (this.guavaOptional == value) {
            return this;
        }
        return new ImmutableOptionalWithNullable(this.javaOptional, this.javaOptionalInt, this.javaOptionalInteger, (com.google.common.base.Optional<String>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOptionalWithNullable && this.equalTo((ImmutableOptionalWithNullable)another);
    }

    private boolean equalTo(ImmutableOptionalWithNullable another) {
        return com.google.common.base.Objects.equal((Object)this.javaOptional, (Object)another.javaOptional) && com.google.common.base.Objects.equal((Object)this.javaOptionalInt, (Object)another.javaOptionalInt) && com.google.common.base.Objects.equal((Object)this.javaOptionalInteger, (Object)another.javaOptionalInteger) && this.guavaOptional.equals(another.guavaOptional);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.javaOptional});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.javaOptionalInt});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.javaOptionalInteger});
        h = h * 17 + this.guavaOptional.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OptionalWithNullable").add("javaOptional", this.getJavaOptional()).add("javaOptionalInt", (Object)this.getJavaOptionalInt()).add("javaOptionalInteger", this.getJavaOptionalInteger()).add("guavaOptional", this.guavaOptional).toString();
    }

    public static ImmutableOptionalWithNullable copyOf(OptionalWithNullable instance) {
        if (instance instanceof ImmutableOptionalWithNullable) {
            return (ImmutableOptionalWithNullable)instance;
        }
        return ImmutableOptionalWithNullable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String javaOptional;
        @Nullable
        private Integer javaOptionalInt;
        @Nullable
        private Integer javaOptionalInteger;
        private com.google.common.base.Optional<String> guavaOptional = com.google.common.base.Optional.absent();

        private Builder() {
        }

        public final Builder from(OptionalWithNullable instance) {
            com.google.common.base.Optional<String> guavaOptionalOptional;
            Optional<Integer> javaOptionalIntegerOptional;
            OptionalInt javaOptionalIntOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> javaOptionalOptional = instance.getJavaOptional();
            if (javaOptionalOptional.isPresent()) {
                this.javaOptional(javaOptionalOptional);
            }
            if ((javaOptionalIntOptional = instance.getJavaOptionalInt()).isPresent()) {
                this.javaOptionalInt(javaOptionalIntOptional);
            }
            if ((javaOptionalIntegerOptional = instance.getJavaOptionalInteger()).isPresent()) {
                this.javaOptionalInteger(javaOptionalIntegerOptional);
            }
            if ((guavaOptionalOptional = instance.getGuavaOptional()).isPresent()) {
                this.guavaOptional(guavaOptionalOptional);
            }
            return this;
        }

        public final Builder javaOptional(@Nullable String javaOptional) {
            this.javaOptional = javaOptional;
            return this;
        }

        public final Builder javaOptional(Optional<String> javaOptional) {
            this.javaOptional = javaOptional.orElse(null);
            return this;
        }

        public final Builder javaOptionalInt(int javaOptionalInt) {
            this.javaOptionalInt = javaOptionalInt;
            return this;
        }

        public final Builder javaOptionalInt(OptionalInt javaOptionalInt) {
            this.javaOptionalInt = javaOptionalInt.isPresent() ? Integer.valueOf(javaOptionalInt.getAsInt()) : null;
            return this;
        }

        public final Builder javaOptionalInteger(@Nullable Integer javaOptionalInteger) {
            this.javaOptionalInteger = javaOptionalInteger;
            return this;
        }

        public final Builder javaOptionalInteger(Optional<Integer> javaOptionalInteger) {
            this.javaOptionalInteger = javaOptionalInteger.orElse(null);
            return this;
        }

        public final Builder guavaOptional(@Nullable String guavaOptional) {
            this.guavaOptional = com.google.common.base.Optional.fromNullable((Object)guavaOptional);
            return this;
        }

        public final Builder guavaOptional(com.google.common.base.Optional<String> guavaOptional) {
            this.guavaOptional = (com.google.common.base.Optional)Preconditions.checkNotNull(guavaOptional, (Object)"guavaOptional");
            return this;
        }

        public ImmutableOptionalWithNullable build() throws IllegalStateException {
            return new ImmutableOptionalWithNullable(this.javaOptional, this.javaOptionalInt, this.javaOptionalInteger, this.guavaOptional);
        }
    }
}

