/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.OptionalWithoutNullable;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableOptionalWithoutNullable
implements OptionalWithoutNullable {
    @Nullable
    private final String javaOptional;
    @Nullable
    private final Integer javaOptionalInt;
    private final com.google.common.base.Optional<String> guavaOptional;

    private ImmutableOptionalWithoutNullable(@Nullable String javaOptional, @Nullable Integer javaOptionalInt, com.google.common.base.Optional<String> guavaOptional) {
        this.javaOptional = javaOptional;
        this.javaOptionalInt = javaOptionalInt;
        this.guavaOptional = guavaOptional;
    }

    @Override
    public Optional<String> getJavaOptional() {
        return Optional.ofNullable(this.javaOptional);
    }

    @Override
    public OptionalInt getJavaOptionalInt() {
        return this.javaOptionalInt != null ? OptionalInt.of(this.javaOptionalInt) : OptionalInt.empty();
    }

    @Override
    public com.google.common.base.Optional<String> getGuavaOptional() {
        return this.guavaOptional;
    }

    public final ImmutableOptionalWithoutNullable withJavaOptional(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"javaOptional");
        if (Objects.equals(this.javaOptional, newValue)) {
            return this;
        }
        return new ImmutableOptionalWithoutNullable(newValue, this.javaOptionalInt, this.guavaOptional);
    }

    public final ImmutableOptionalWithoutNullable withJavaOptional(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.javaOptional, value)) {
            return this;
        }
        return new ImmutableOptionalWithoutNullable(value, this.javaOptionalInt, this.guavaOptional);
    }

    public final ImmutableOptionalWithoutNullable withJavaOptionalInt(int value) {
        Integer newValue = value;
        if (this.javaOptionalInt == newValue) {
            return this;
        }
        return new ImmutableOptionalWithoutNullable(this.javaOptional, newValue, this.guavaOptional);
    }

    public final ImmutableOptionalWithoutNullable withJavaOptionalInt(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (this.javaOptionalInt == value) {
            return this;
        }
        return new ImmutableOptionalWithoutNullable(this.javaOptional, value, this.guavaOptional);
    }

    public final ImmutableOptionalWithoutNullable withGuavaOptional(String value) {
        com.google.common.base.Optional newValue = com.google.common.base.Optional.of((Object)value);
        return new ImmutableOptionalWithoutNullable(this.javaOptional, this.javaOptionalInt, (com.google.common.base.Optional<String>)newValue);
    }

    public final ImmutableOptionalWithoutNullable withGuavaOptional(com.google.common.base.Optional<String> optional) {
        com.google.common.base.Optional value = (com.google.common.base.Optional)Preconditions.checkNotNull(optional, (Object)"guavaOptional");
        if (this.guavaOptional == value) {
            return this;
        }
        return new ImmutableOptionalWithoutNullable(this.javaOptional, this.javaOptionalInt, (com.google.common.base.Optional<String>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOptionalWithoutNullable && this.equalTo((ImmutableOptionalWithoutNullable)another);
    }

    private boolean equalTo(ImmutableOptionalWithoutNullable another) {
        return com.google.common.base.Objects.equal((Object)this.javaOptional, (Object)another.javaOptional) && com.google.common.base.Objects.equal((Object)this.javaOptionalInt, (Object)another.javaOptionalInt) && this.guavaOptional.equals(another.guavaOptional);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.javaOptional});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.javaOptionalInt});
        h = h * 17 + this.guavaOptional.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OptionalWithoutNullable").add("javaOptional", this.getJavaOptional()).add("javaOptionalInt", (Object)this.getJavaOptionalInt()).add("guavaOptional", this.guavaOptional).toString();
    }

    public static ImmutableOptionalWithoutNullable copyOf(OptionalWithoutNullable instance) {
        if (instance instanceof ImmutableOptionalWithoutNullable) {
            return (ImmutableOptionalWithoutNullable)instance;
        }
        return ImmutableOptionalWithoutNullable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String javaOptional;
        @Nullable
        private Integer javaOptionalInt;
        private com.google.common.base.Optional<String> guavaOptional = com.google.common.base.Optional.absent();

        private Builder() {
        }

        public final Builder from(OptionalWithoutNullable instance) {
            com.google.common.base.Optional<String> guavaOptionalOptional;
            OptionalInt javaOptionalIntOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> javaOptionalOptional = instance.getJavaOptional();
            if (javaOptionalOptional.isPresent()) {
                this.javaOptional(javaOptionalOptional);
            }
            if ((javaOptionalIntOptional = instance.getJavaOptionalInt()).isPresent()) {
                this.javaOptionalInt(javaOptionalIntOptional);
            }
            if ((guavaOptionalOptional = instance.getGuavaOptional()).isPresent()) {
                this.guavaOptional(guavaOptionalOptional);
            }
            return this;
        }

        public final Builder javaOptional(String javaOptional) {
            this.javaOptional = (String)Preconditions.checkNotNull((Object)javaOptional, (Object)"javaOptional");
            return this;
        }

        public final Builder javaOptional(Optional<String> javaOptional) {
            this.javaOptional = javaOptional.orElse(null);
            return this;
        }

        public final Builder javaOptionalInt(int javaOptionalInt) {
            this.javaOptionalInt = javaOptionalInt;
            return this;
        }

        public final Builder javaOptionalInt(OptionalInt javaOptionalInt) {
            this.javaOptionalInt = javaOptionalInt.isPresent() ? Integer.valueOf(javaOptionalInt.getAsInt()) : null;
            return this;
        }

        public final Builder guavaOptional(String guavaOptional) {
            this.guavaOptional = com.google.common.base.Optional.of((Object)guavaOptional);
            return this;
        }

        public final Builder guavaOptional(com.google.common.base.Optional<String> guavaOptional) {
            this.guavaOptional = (com.google.common.base.Optional)Preconditions.checkNotNull(guavaOptional, (Object)"guavaOptional");
            return this;
        }

        public ImmutableOptionalWithoutNullable build() throws IllegalStateException {
            return new ImmutableOptionalWithoutNullable(this.javaOptional, this.javaOptionalInt, this.guavaOptional);
        }
    }
}

