/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.fixture.style.OverrideColor;

@ParametersAreNonnullByDefault
@Immutable
final class OverrideColorTuple
implements OverrideColor {
    private final int white;
    private final int black;
    private final int gray;

    private OverrideColorTuple(int white, int black) {
        this.white = white;
        this.black = black;
        this.gray = OverrideColor.super.gray();
    }

    private OverrideColorTuple(int white, int black, int gray) {
        this.white = white;
        this.black = black;
        this.gray = gray;
    }

    @Override
    public int white() {
        return this.white;
    }

    @Override
    public int black() {
        return this.black;
    }

    @Override
    public int gray() {
        return this.gray;
    }

    public final OverrideColorTuple withWhite(int value) {
        if (this.white == value) {
            return this;
        }
        return new OverrideColorTuple(value, this.black, this.gray);
    }

    public final OverrideColorTuple withBlack(int value) {
        if (this.black == value) {
            return this;
        }
        return new OverrideColorTuple(this.white, value, this.gray);
    }

    public final OverrideColorTuple withGray(int value) {
        if (this.gray == value) {
            return this;
        }
        return new OverrideColorTuple(this.white, this.black, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OverrideColorTuple && this.equalTo((OverrideColorTuple)another);
    }

    private boolean equalTo(OverrideColorTuple another) {
        return this.white == another.white && this.black == another.black && this.gray == another.gray;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.white;
        h = h * 17 + this.black;
        h = h * 17 + this.gray;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OverrideColor").add("white", this.white).add("black", this.black).add("gray", this.gray).toString();
    }

    public static OverrideColorTuple of(int white, int black) {
        return new OverrideColorTuple(white, black);
    }

    public static OverrideColorTuple copyOf(OverrideColor instance) {
        if (instance instanceof OverrideColorTuple) {
            return (OverrideColorTuple)instance;
        }
        return OverrideColorTuple.of(instance.white(), instance.black()).withGray(instance.gray());
    }
}

