/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.AbstractValueNamingDetected;

@ParametersAreNonnullByDefault
@Immutable
public final class ValueNamingDetected
extends AbstractValueNamingDetected {
    private final int val;
    private final ImmutableSet<String> str;

    private ValueNamingDetected(int val, ImmutableSet<String> str) {
        this.val = val;
        this.str = str;
    }

    @Override
    public int extractVal() {
        return this.val;
    }

    public ImmutableSet<String> collectStr() {
        return this.str;
    }

    public final ValueNamingDetected withVal(int value) {
        if (this.val == value) {
            return this;
        }
        return new ValueNamingDetected(value, this.str);
    }

    public final ValueNamingDetected withStr(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ValueNamingDetected(this.val, (ImmutableSet<String>)newValue);
    }

    public final ValueNamingDetected withStr(Iterable<String> elements) {
        if (this.str == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ValueNamingDetected(this.val, (ImmutableSet<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ValueNamingDetected && this.equalTo((ValueNamingDetected)another);
    }

    private boolean equalTo(ValueNamingDetected another) {
        return this.val == another.val && this.str.equals(another.str);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.val;
        h = h * 17 + this.str.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ValueNamingDetected").add("val", this.val).add("str", this.str).toString();
    }

    static ValueNamingDetected copyOf(AbstractValueNamingDetected instance) {
        if (instance instanceof ValueNamingDetected) {
            return (ValueNamingDetected)instance;
        }
        return ValueNamingDetected.newBuilder().from(instance).buildValueNamingDetected();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VAL = 1L;
        private long initBits = 1L;
        private int val;
        private ImmutableSet.Builder<String> strBuilder = ImmutableSet.builder();

        private Builder() {
        }

        public final Builder from(ValueNamingDetected instance) {
            return this.from((AbstractValueNamingDetected)instance);
        }

        final Builder from(AbstractValueNamingDetected instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.usingVal(instance.extractVal());
            this.addAllStr(instance.collectStr());
            return this;
        }

        public final Builder usingVal(int val) {
            this.val = val;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder withStrAppended(String element) {
            this.strBuilder.add((Object)element);
            return this;
        }

        public final Builder withStrAppended(String ... elements) {
            this.strBuilder.add((Object[])elements);
            return this;
        }

        public final Builder usingStr(Iterable<String> elements) {
            this.strBuilder = ImmutableSet.builder();
            return this.addAllStr(elements);
        }

        public final Builder addAllStr(Iterable<String> elements) {
            this.strBuilder.addAll(elements);
            return this;
        }

        public ValueNamingDetected buildValueNamingDetected() throws IllegalStateException {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ValueNamingDetected(this.val, this.strBuilder.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("val");
            }
            return "Cannot build ValueNamingDetected, some of required attributes are not set " + attributes;
        }
    }
}

