/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.subpack;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.immutables.fixture.subpack.SillySubstructure;
import org.immutables.gson.adapter.FieldNamingTranslator;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;

@ParametersAreNonnullByDefault
@ThreadSafe
public final class SillySubstructureRepository
extends Repositories.Repository<SillySubstructure> {
    private static final String DOCUMENT_COLLECTION_NAME = "sillySubstructure";
    private final Serialization serialization = new Serialization(this.getGson());
    private final Criteria anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());

    public SillySubstructureRepository(RepositorySetup configuration) {
        super(configuration, DOCUMENT_COLLECTION_NAME, SillySubstructure.class);
    }

    public FluentFuture<Integer> insert(SillySubstructure document) {
        return super.doInsert(ImmutableList.of((Object)document));
    }

    public FluentFuture<Integer> insert(Iterable<? extends SillySubstructure> documents) {
        return super.doInsert(ImmutableList.copyOf(documents));
    }

    @CheckReturnValue
    public Finder findAll() {
        return this.find(this.criteria());
    }

    @CheckReturnValue
    public Finder find(String jsonCriteria) {
        return new Finder(this, Support.jsonQuery((String)jsonCriteria));
    }

    @CheckReturnValue
    public Finder find(Criteria criteria) {
        return new Finder(this, (Constraints.ConstraintHost)criteria.constraint);
    }

    @CheckReturnValue
    public Updater update(Criteria criteria) {
        return new Updater(this, criteria);
    }

    @CheckReturnValue
    public Indexer index() {
        return new Indexer(this);
    }

    public Criteria criteria() {
        return this.anyCriteria;
    }

    private static class Serialization {
        private static final TypeToken<RetentionPolicy> ENUM1_TYPE_TOKEN = TypeToken.get(RetentionPolicy.class);
        private static final TypeToken<ElementType> SET2_TYPE_TOKEN = TypeToken.get(ElementType.class);
        final TypeAdapter<RetentionPolicy> enum1TypeAdapter;
        final TypeAdapter<ElementType> set2TypeAdapter;
        final Gson gson;
        final String enum1Name;
        final String set2Name;
        final String set3Name;
        final String floats4Name;

        Serialization(Gson gson) {
            this.gson = gson;
            this.enum1TypeAdapter = gson.getAdapter(ENUM1_TYPE_TOKEN);
            this.set2TypeAdapter = gson.getAdapter(SET2_TYPE_TOKEN);
            FieldNamingTranslator fieldNaming = new FieldNamingTranslator(gson);
            this.enum1Name = fieldNaming.translateName(SillySubstructure.class, RetentionPolicy.class, "enum1", "");
            this.set2Name = fieldNaming.translateName(SillySubstructure.class, Set.class, "set2", "");
            this.set3Name = fieldNaming.translateName(SillySubstructure.class, Set.class, "set3", "");
            this.floats4Name = fieldNaming.translateName(SillySubstructure.class, List.class, "floats4", "");
        }
    }

    @Immutable
    public static final class Criteria
    extends Repositories.Criteria {
        private final Constraints.Constraint constraint;
        private final Serialization serialization;

        Criteria(Serialization serialization, Constraints.Constraint constraint) {
            this.constraint = constraint;
            this.serialization = serialization;
        }

        public Criteria enum1(RetentionPolicy value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.enum1Name, false, Support.writable(this.serialization.enum1TypeAdapter, (Object)((Object)value))));
        }

        public Criteria enum1Not(RetentionPolicy value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.enum1Name, true, Support.writable(this.serialization.enum1TypeAdapter, (Object)((Object)value))));
        }

        public Criteria enum1In(Iterable<RetentionPolicy> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (RetentionPolicy value : values) {
                wrappedValues.add(Support.writable(this.serialization.enum1TypeAdapter, (Object)((Object)value)));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.enum1Name, false, (Iterable)wrappedValues));
        }

        public Criteria enum1In(RetentionPolicy first, RetentionPolicy second, RetentionPolicy ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable(this.serialization.enum1TypeAdapter, (Object)((Object)first)));
            values.add(Support.writable(this.serialization.enum1TypeAdapter, (Object)((Object)second)));
            for (RetentionPolicy value : rest) {
                values.add(Support.writable(this.serialization.enum1TypeAdapter, (Object)((Object)value)));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.enum1Name, false, (Iterable)values));
        }

        public Criteria enum1NotIn(Iterable<RetentionPolicy> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (RetentionPolicy value : values) {
                wrappedValues.add(Support.writable(this.serialization.enum1TypeAdapter, (Object)((Object)value)));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.enum1Name, true, (Iterable)wrappedValues));
        }

        public Criteria enum1NotIn(RetentionPolicy first, RetentionPolicy second, RetentionPolicy ... rest) {
            ArrayList values = Lists.newArrayListWithCapacity((int)(2 + rest.length));
            values.add(Support.writable(this.serialization.enum1TypeAdapter, (Object)((Object)first)));
            values.add(Support.writable(this.serialization.enum1TypeAdapter, (Object)((Object)second)));
            for (RetentionPolicy value : rest) {
                values.add(Support.writable(this.serialization.enum1TypeAdapter, (Object)((Object)value)));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.enum1Name, true, (Iterable)values));
        }

        public Criteria enum1GreaterThan(RetentionPolicy lower) {
            return this.enum1In((Range<RetentionPolicy>)Range.greaterThan((Comparable)((Object)lower)));
        }

        public Criteria enum1LessThan(RetentionPolicy upper) {
            return this.enum1In((Range<RetentionPolicy>)Range.lessThan((Comparable)((Object)upper)));
        }

        public Criteria enum1AtMost(RetentionPolicy upperInclusive) {
            return this.enum1In((Range<RetentionPolicy>)Range.atMost((Comparable)((Object)upperInclusive)));
        }

        public Criteria enum1AtLeast(RetentionPolicy lowerInclusive) {
            return this.enum1In((Range<RetentionPolicy>)Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        public Criteria enum1In(Range<RetentionPolicy> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.enum1Name, false, Support.writable(this.serialization.enum1TypeAdapter, range)));
        }

        public Criteria enum1NotIn(Range<RetentionPolicy> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.enum1Name, true, Support.writable(this.serialization.enum1TypeAdapter, range)));
        }

        public Criteria set2Empty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.set2Name, false, 0));
        }

        public Criteria set2NonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.set2Name, true, 0));
        }

        public Criteria set2Size(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.set2Name, false, size));
        }

        public Criteria set2Contains(ElementType value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.set2Name, false, Support.writable(this.serialization.set2TypeAdapter, (Object)((Object)value))));
        }

        public Criteria set2ContainsAll(Iterable<ElementType> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (ElementType value : values) {
                wrappedValues.add(Support.writable(this.serialization.set2TypeAdapter, (Object)((Object)value)));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.set2Name, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, (Object)wrappedValues)));
        }

        public Criteria set3Empty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.set3Name, false, 0));
        }

        public Criteria set3NonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.set3Name, true, 0));
        }

        public Criteria set3Size(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.set3Name, false, size));
        }

        public Criteria set3Contains(int value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.set3Name, false, Support.writable((Object)value)));
        }

        public Criteria set3ContainsAll(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.set3Name, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, (Object)wrappedValues)));
        }

        public Criteria floats4Empty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.floats4Name, false, 0));
        }

        public Criteria floats4NonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.floats4Name, true, 0));
        }

        public Criteria floats4Size(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.floats4Name, false, size));
        }

        public Criteria floats4Contains(float value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.floats4Name, false, Support.writable((Object)Float.valueOf(value))));
        }

        public Criteria floats4ContainsAll(Iterable<Float> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Float value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.floats4Name, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, (Object)wrappedValues)));
        }

        public Criteria or() {
            return new Criteria(this.serialization, this.constraint.disjunction());
        }

        public String toString() {
            return "SillySubstructureRepository.criteria(" + Support.stringify((Constraints.ConstraintHost)this.constraint) + ")";
        }
    }

    @NotThreadSafe
    public static final class Indexer
    extends Repositories.Indexer<SillySubstructure, Indexer> {
        private final Serialization serialization;

        private Indexer(SillySubstructureRepository repository) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
        }

        public Indexer withEnum1() {
            this.fields = this.fields.equal(this.serialization.enum1Name, false, (Object)1);
            return this;
        }

        public Indexer withEnum1Desceding() {
            this.fields = this.fields.equal(this.serialization.enum1Name, false, (Object)-1);
            return this;
        }

        public Indexer withSet2() {
            this.fields = this.fields.equal(this.serialization.set2Name, false, (Object)1);
            return this;
        }

        public Indexer withSet2Desceding() {
            this.fields = this.fields.equal(this.serialization.set2Name, false, (Object)-1);
            return this;
        }

        public Indexer withSet3() {
            this.fields = this.fields.equal(this.serialization.set3Name, false, (Object)1);
            return this;
        }

        public Indexer withSet3Desceding() {
            this.fields = this.fields.equal(this.serialization.set3Name, false, (Object)-1);
            return this;
        }

        public Indexer withFloats4() {
            this.fields = this.fields.equal(this.serialization.floats4Name, false, (Object)1);
            return this;
        }

        public Indexer withFloats4Desceding() {
            this.fields = this.fields.equal(this.serialization.floats4Name, false, (Object)-1);
            return this;
        }
    }

    @NotThreadSafe
    public static final class Modifier
    extends Repositories.Modifier<SillySubstructure, Modifier> {
        private final Serialization serialization;

        private Modifier(SillySubstructureRepository repository, Constraints.ConstraintHost criteria, Constraints.Constraint ordering, Constraints.Constraint exclusion) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
            this.criteria = criteria;
            this.ordering = ordering;
            this.exclusion = exclusion;
        }

        public Modifier setEnum1(RetentionPolicy value) {
            this.setFields = this.setFields.equal(this.serialization.enum1Name, false, Support.writable(this.serialization.enum1TypeAdapter, (Object)((Object)value)));
            return this;
        }

        public Modifier initEnum1(RetentionPolicy value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.enum1Name, false, Support.writable(this.serialization.enum1TypeAdapter, (Object)((Object)value)));
            return this;
        }

        public Modifier clearSet2() {
            this.setFields = this.setFields.equal(this.serialization.set2Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Modifier removeSet2(ElementType value) {
            this.pullFields = this.pullFields.equal(this.serialization.set2Name, false, Support.writable(this.serialization.set2TypeAdapter, (Object)((Object)value)));
            return this;
        }

        public Modifier addSet2(ElementType value) {
            this.pushFields = this.pushFields.equal(this.serialization.set2Name, false, Support.writable(this.serialization.set2TypeAdapter, (Object)((Object)value)));
            return this;
        }

        public Modifier addAllSet2(Iterable<ElementType> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (ElementType value : values) {
                wrappedValues.add(Support.writable(this.serialization.set2TypeAdapter, (Object)((Object)value)));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", (Object)wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.set2Name, false, v);
            return this;
        }

        public Modifier clearSet3() {
            this.setFields = this.setFields.equal(this.serialization.set3Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Modifier removeSet3(int value) {
            this.pullFields = this.pullFields.equal(this.serialization.set3Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier addSet3(int value) {
            this.addToSetFields = this.addToSetFields.equal(this.serialization.set3Name, false, Support.writable((Object)value));
            return this;
        }

        public Modifier addAllSet3(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", (Object)wrappedValues);
            this.addToSetFields = this.addToSetFields.equal(this.serialization.set3Name, false, v);
            return this;
        }

        public Modifier clearFloats4() {
            this.setFields = this.setFields.equal(this.serialization.floats4Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Modifier removeFloats4(float value) {
            this.pullFields = this.pullFields.equal(this.serialization.floats4Name, false, Support.writable((Object)Float.valueOf(value)));
            return this;
        }

        public Modifier addFloats4(float value) {
            this.pushFields = this.pushFields.equal(this.serialization.floats4Name, false, Support.writable((Object)Float.valueOf(value)));
            return this;
        }

        public Modifier addAllFloats4(Iterable<Float> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Float value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", (Object)wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.floats4Name, false, v);
            return this;
        }
    }

    @NotThreadSafe
    public static final class Updater
    extends Repositories.Updater<SillySubstructure> {
        private final Serialization serialization;

        private Updater(SillySubstructureRepository repository, Criteria criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria.constraint;
            this.serialization = repository.serialization;
        }

        public Updater setEnum1(RetentionPolicy value) {
            this.setFields = this.setFields.equal(this.serialization.enum1Name, false, Support.writable(this.serialization.enum1TypeAdapter, (Object)((Object)value)));
            return this;
        }

        public Updater initEnum1(RetentionPolicy value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.enum1Name, false, Support.writable(this.serialization.enum1TypeAdapter, (Object)((Object)value)));
            return this;
        }

        public Updater clearSet2() {
            this.setFields = this.setFields.equal(this.serialization.set2Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Updater removeSet2(ElementType value) {
            this.pullFields = this.pullFields.equal(this.serialization.set2Name, false, Support.writable(this.serialization.set2TypeAdapter, (Object)((Object)value)));
            return this;
        }

        public Updater addSet2(ElementType value) {
            this.pushFields = this.pushFields.equal(this.serialization.set2Name, false, Support.writable(this.serialization.set2TypeAdapter, (Object)((Object)value)));
            return this;
        }

        public Updater addAllSet2(Iterable<ElementType> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (ElementType value : values) {
                wrappedValues.add(Support.writable(this.serialization.set2TypeAdapter, (Object)((Object)value)));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", (Object)wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.set2Name, false, v);
            return this;
        }

        public Updater clearSet3() {
            this.setFields = this.setFields.equal(this.serialization.set3Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Updater removeSet3(int value) {
            this.pullFields = this.pullFields.equal(this.serialization.set3Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater addSet3(int value) {
            this.addToSetFields = this.addToSetFields.equal(this.serialization.set3Name, false, Support.writable((Object)value));
            return this;
        }

        public Updater addAllSet3(Iterable<Integer> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Integer value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", (Object)wrappedValues);
            this.addToSetFields = this.addToSetFields.equal(this.serialization.set3Name, false, v);
            return this;
        }

        public Updater clearFloats4() {
            this.setFields = this.setFields.equal(this.serialization.floats4Name, false, (Object)ImmutableList.of());
            return this;
        }

        public Updater removeFloats4(float value) {
            this.pullFields = this.pullFields.equal(this.serialization.floats4Name, false, Support.writable((Object)Float.valueOf(value)));
            return this;
        }

        public Updater addFloats4(float value) {
            this.pushFields = this.pushFields.equal(this.serialization.floats4Name, false, Support.writable((Object)Float.valueOf(value)));
            return this;
        }

        public Updater addAllFloats4(Iterable<Float> values) {
            ArrayList wrappedValues = Lists.newArrayList();
            for (Float value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", (Object)wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.floats4Name, false, v);
            return this;
        }
    }

    @NotThreadSafe
    public static final class Finder
    extends Repositories.Finder<SillySubstructure, Finder> {
        private final Serialization serialization;

        private Finder(SillySubstructureRepository repository, Constraints.ConstraintHost criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria;
            this.serialization = repository.serialization;
        }

        public Finder orderByEnum1() {
            this.ordering = this.ordering.equal(this.serialization.enum1Name, false, (Object)1);
            return this;
        }

        public Finder orderByEnum1Desceding() {
            this.ordering = this.ordering.equal(this.serialization.enum1Name, false, (Object)-1);
            return this;
        }

        public Finder orderBySet2() {
            this.ordering = this.ordering.equal(this.serialization.set2Name, false, (Object)1);
            return this;
        }

        public Finder orderBySet2Desceding() {
            this.ordering = this.ordering.equal(this.serialization.set2Name, false, (Object)-1);
            return this;
        }

        public Finder orderBySet3() {
            this.ordering = this.ordering.equal(this.serialization.set3Name, false, (Object)1);
            return this;
        }

        public Finder orderBySet3Desceding() {
            this.ordering = this.ordering.equal(this.serialization.set3Name, false, (Object)-1);
            return this;
        }

        public Finder orderByFloats4() {
            this.ordering = this.ordering.equal(this.serialization.floats4Name, false, (Object)1);
            return this;
        }

        public Finder orderByFloats4Desceding() {
            this.ordering = this.ordering.equal(this.serialization.floats4Name, false, (Object)-1);
            return this;
        }

        public Finder excludeSet2() {
            this.exclusion = this.exclusion.equal(this.serialization.set2Name, false, (Object)-1);
            return this;
        }

        public Finder excludeSet3() {
            this.exclusion = this.exclusion.equal(this.serialization.set3Name, false, (Object)-1);
            return this;
        }

        public Finder excludeFloats4() {
            this.exclusion = this.exclusion.equal(this.serialization.floats4Name, false, (Object)-1);
            return this;
        }

        @CheckReturnValue
        public Modifier andModifyFirst() {
            return new Modifier((SillySubstructureRepository)this.repository, this.criteria, this.ordering, this.exclusion);
        }
    }
}

