package org.immutables.vavr.examples;

import io.vavr.collection.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ExampleArrayType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExampleArrayType.builder()}.
 */
@SuppressWarnings({"all"})
@Generated(from = "ExampleArrayType", generator = "Immutables")
public final class ImmutableExampleArrayType implements ExampleArrayType {
  private final Array<Integer> integers;

  private ImmutableExampleArrayType(Array<Integer> integers) {
    this.integers = integers;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build ExampleArrayType, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return Some data
   */
  @Override
  public Array<Integer> integers() {
    return integers;
  }

  public ImmutableExampleArrayType withIntegers(Array<Integer> value) {
    Array<Integer> newValue = value;
    if (this.integers == newValue) return this;
    return new ImmutableExampleArrayType(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExampleArrayType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExampleArrayType
        && equalTo((ImmutableExampleArrayType) another);
  }

  private boolean equalTo(ImmutableExampleArrayType another) {
    return this.integers().equals(another.integers());
  }

  /**
   * Computes a hash code from attributes: {@code integers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (integers().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code ExampleArrayType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ExampleArrayType{"
        + "integers=" + (integers().toString())
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ExampleArrayType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ExampleArrayType instance
   */
  public static ImmutableExampleArrayType copyOf(ExampleArrayType instance) {
    if (instance instanceof ImmutableExampleArrayType) {
      return (ImmutableExampleArrayType) instance;
    }
    return ImmutableExampleArrayType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExampleArrayType ImmutableExampleArrayType}.
   * @return A new ImmutableExampleArrayType builder
   */
  public static ImmutableExampleArrayType.Builder builder() {
    return new ImmutableExampleArrayType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExampleArrayType ImmutableExampleArrayType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Array<Integer> integers_array = Array.empty();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ExampleArrayType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ExampleArrayType instance) {
      Objects.requireNonNull(instance, "instance");
      integers(instance.integers());
      return this;
    }

    public Builder addIntegers(Integer element) {
      this.integers_array = this.integers_array.append(element);
      return this;
    }

    @SafeVarargs
    public final Builder addIntegers(Integer... elements) {
      this.integers_array = this.integers_array.appendAll(Arrays.asList(elements));
      return this;
    }

    public Builder addAllIntegers(Iterable<Integer> element) {
      this.integers_array = this.integers_array.appendAll(element);
      return this;
    }

    public Builder integers(Array<Integer> elements) {
      this.integers_array = elements;
      return this;
    }

    public Builder setIterableIntegers(Iterable<Integer> elements) {
      this.integers_array = Array.ofAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableExampleArrayType ImmutableExampleArrayType}.
     * @return An immutable instance of ExampleArrayType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExampleArrayType build() {
      return new ImmutableExampleArrayType(integers_build());
    }

    private Array<Integer> integers_build() {
      return this.integers_array;
    }
  }
}
